% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddtlcm-package.R
\docType{package}
\name{ddtlcm}
\alias{ddtlcm}
\title{Dirichlet diffusion tree-latent class model (DDT-LCM)}
\description{
\code{ddtlcm} is designed for
clustering multivariate binary observations over grouped items while (1) leveraging between-cluster similarities guided
by an unknown tree that is simultaneously estimated, and (2) accounting for varying degrees of
shrinkage across major item groups. Classes positioned closer on the tree exhibit more similarities a priori.
The model guards against potential numerical and statistical instability of classical LCMs especially
when classes are weakly separated under small sample sizes. This is achieved by equipping a LCM with
a DDT process prior on the class profiles, which are the class-conditional response probabilities. The
posterior inference algorithm is based on Metropolis-Hastings algorithm for sampling the tree structure, and
Gibbs sampler with Polya-Gamma augmentation for the LCM parameters.
}
\section{main ddtlcm wrapper function}{

\code{\link[=ddtlcm_fit]{ddtlcm_fit()}}
}

\seealso{
\itemize{
\item \url{https://github.com/limengbinggz/ddtlcm} for the source code
and system/software requirements to use \code{ddtlcm} for your data.
}
}
