# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title C++ code to build models, internal function
#' @description
#' Build a ddsPLS model once the bootstrap operations has allowed to find a correct lambda.
#' @param U The weights for X part.
#' @param V The weights for Y part.
#' @param X The matrix of X part.
#' @param Y The matrix of X part.
#' @param lambdas The to be tested values for lambda.
#' @param R The number of components to build.
#' @param n The number of observations.
#' @param p The number of variables of X part.
#' @param q The number of variables of Y part.
#' @param lambda0 The lowest value to be tested for lambda.
#'
#' @return A list containing the PLS parameters:
#' \itemize{
#'   \item \code{$P}: Loadings for \code{X}.
#'   \item \code{$C}: Loadings for \code{Y}.
#'   \item \code{$t}: Scores.
#'   \item \code{$V}: Weights for \code{Y}.
#'   \item \code{$U}: Loadings for \code{X}.
#'   \item \code{$U_star}: Loadings for \code{X} in original base: $U_star=U(P'U)^{-1}$.
#'   \item \code{$B}: Regression matrix of \code{Y} on \code{X}.
#'   \item \code{$muY}: Empirical mean of \code{Y}.
#'   \item \code{$muX}: Empirical mean of \code{X}.
#'   \item \code{$sdY}: Empirical standard deviation of \code{Y}.
#'   \item \code{$sdX}: Empirical standard deviation of \code{X}.
#'}
#'
modelddsPLSCpp_Rcpp <- function(U, V, X, Y, lambdas, R, n, p, q, lambda0) {
    .Call(`_ddsPLS_modelddsPLSCpp_Rcpp`, U, V, X, Y, lambdas, R, n, p, q, lambda0)
}

#' @title C++ implementation of the bootstrap operations
#' @description
#' Start the bootstrap operations.
#' Should not be used by user.
#' @param U The weights for X part.
#' @param V The weights for Y part.
#' @param X The matrix of X part.
#' @param Y The matrix of X part.
#' @param lambdas The to be tested values for lambda.
#' @param lambda_prev The previously selected values for lambda.
#' @param R The number of components to build.
#' @param n_B The number of bootstrap samples to generate and analyse.
#' @param doBoot Wheteher do bootstrap operations.
#' @param n The number of observations.
#' @param p The number of variables of X part.
#' @param q The number of variables of Y part.
#' @param N_lambdas The number of to be tested values for lambda.
#' @param lambda0 The minimum value to be checked in lambdas.
#'
#' @return The bootstrapped statistics
#'
bootstrap_Rcpp <- function(U, V, X, Y, lambdas, lambda_prev, R, n_B, doBoot, n, p, q, N_lambdas, lambda0) {
    .Call(`_ddsPLS_bootstrap_Rcpp`, U, V, X, Y, lambdas, lambda_prev, R, n_B, doBoot, n, p, q, N_lambdas, lambda0)
}

