% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-extend.R
\name{define_steps}
\alias{define_steps}
\title{Define analysis steps}
\usage{
define_steps(plate)
}
\arguments{
\item{plate}{A ddPCR plate}
}
\value{
A named list of analysis steps in the order they should be run on a dataset.
The name of each item in the list is the human-readable name of the step
and the value of each item is the function to call to perform the step.
}
\description{
Every ddPCR plate type has an ordered set of steps that are run to analyze
the data. When creating a new plate type, if your plate type has different
analysis steps than its parent type, you must define this function to return
a named list of the analysis steps. When defining this function, you can use 
\code{NextMethod("define_steps")} to get a list of the steps available in
the parent type if you want to simply add new steps without defining all of them.
}
\seealso{
\code{\link[ddpcr]{steps}}\cr
\code{\link[ddpcr]{step_begin}}\cr
\code{\link[ddpcr]{step_end}}\cr
\code{\link[ddpcr]{parent_plate_type}}\cr
\code{\link[ddpcr]{define_clusters}}\cr
\code{\link[ddpcr]{define_params}}
}
\keyword{internal}
