% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plate-attribs.R
\name{unanalyzed_clusters}
\alias{unanalyzed_clusters}
\title{Get unanalyzed cluseter IDs}
\usage{
unanalyzed_clusters(plate, current)
}
\arguments{
\item{plate}{A ddPCR plate}

\item{current}{The current cluster ID, which is used to know what clusters
come after}
}
\value{
All clusters that have not yet been analyzed
}
\description{
Get the clusters that have not been considered yet in the analysis. This means
the UNDEFINED cluster (since all droplets begin as UNDEFINED) and also all
clusters that are defined later than the current cluster. The latter is to
ensure that when re-running an analysis step, droplets that were analyzed
in a later step will still be considered for analysis.
}
\examples{
\dontrun{
plate <- new_plate(sample_data_dir())
unanalyzed_clusters(plate, 3)
unanalyzed_clusters(plate, cluster(plate, "OUTLIER"))
plate \%>\% unanalyzed_clusters(cluster(plate, "OUTLIER")) \%>\% cluster_name(plate, .)
}
}
\seealso{
\code{\link[ddpcr]{cluster}}
}
\keyword{internal}

