% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-duplicate-paths.R
\name{check_duplicate_paths}
\alias{check_duplicate_paths}
\title{Check for duplicated file paths}
\usage{
check_duplicate_paths(
  data,
  success_msg = "No duplicate file paths detected",
  fail_msg = "Duplicate file paths detected"
)
}
\arguments{
\item{data}{Data to check}

\item{success_msg}{Message indicating the check succeeded.}

\item{fail_msg}{Message indicating the check failed.}
}
\value{
A condition object indicating whether the data contains duplicated
file paths in the \code{parent} column.
}
\description{
The \code{parent} column in the manifest should not contain duplicated file paths.
This function checks if any paths are duplicated.
}
\details{
It is possible for this function to return false negatives if the same path
is written in different ways. For example, \code{"~/file.txt"} and
\code{"/Users/me/file.txt"} will be treated as different paths even if they
resolve to the same location on the user's machine. Because this function is
typically run from a Shiny app without access to the user's filesystem, it is
not possible to detect every possible duplicate path.
}
\examples{
manifest <- data.frame(
  path = c("/path/to/file.txt", "/path/to/file.txt"),
  parent = c("syn123", "syn123")
)
check_duplicate_paths(manifest)
}
