% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-annotation-values.R
\name{can_coerce}
\alias{can_coerce}
\title{Check coercibility}
\usage{
can_coerce(values, class)
}
\arguments{
\item{values}{Vector of values to check}

\item{class}{Class of interest}
}
\value{
Boolean value; TRUE if \code{values} are coercible to \code{class}, \code{FALSE}
otherwise.
}
\description{
Checks if values are coercible to a given class. Because of inconsistencies
in R's built-in coercion functions (e.g. \code{as.numeric()} warns when it
introduces NAs but \code{as.logical()} doesn't; \code{as.integer()} will silently
remove decimal places from numeric inputs) we check only for the specific
coercions we want to allow, currently: numeric, integer, or logical to string
}
\details{
This function is mainly in place so that we can automatically allow numeric
read lengths, pH values, etc., which are defined as strings in our annotation
vocabulary but can reasonably be numbers.

This function will also return \code{TRUE} if the values are integers and the
desired class is numeric.

This function will \emph{not} affect validation of enumerated values, regardless
of their class. It is only used when validating annotations that have a
required type but no enumerated values.
}
\examples{
# Not run because function is not exported
\dontrun{
# Coercible:
can_coerce(1, "character")
can_coerce(TRUE, "character")
can_coerce(1L, "character")
can_coerce(1L, "numeric")

# Not coercible:
can_coerce("foo", "numeric")
can_coerce("foo", "logical")
can_coerce(2.5, "integer")
}
}
\seealso{
\code{\link[=check_annotation_values]{check_annotation_values()}}
}
