% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ident.R
\name{ident}
\alias{ident}
\alias{ident_q}
\alias{is.ident}
\title{Flag a character vector as SQL identifiers}
\usage{
ident(...)

ident_q(...)

is.ident(x)
}
\arguments{
\item{...}{A character vector, or name-value pairs}

\item{x}{An object}
}
\description{
\code{ident()} takes unquoted strings and quotes them for you; \code{ident_q()}
assumes its input has already been quoted.
}
\details{
These two \code{ident} clsases are used during SQL generation to make sure
the values will be quoted as, not as strings.
}
\examples{
# SQL92 quotes strings with '
escape("x")

# And identifiers with "
ident("x")

# You can supply multiple inputs
ident(a = "x", b = "y")
ident_q(a = "x", b = "y")
}
