% Generated by roxygen2 (4.0.2): do not edit by hand
\name{db.new}
\alias{db.new}
\title{Connection to a database}
\usage{
db.new(hostname = NA, port = NA, username = NA, password = NA,
  dbname = NA, filename = NA, dbtype = NA, profile = NA)
}
\arguments{
\item{hostname}{the hostname for your database (i.e. dw.muppets.com)}

\item{port}{the port for your database (i.e. 5432 or 3309)}

\item{username}{the username for your database (i.e. kermit)}

\item{password}{the password for your database (i.e. supersecret)}

\item{dbname}{the dbname for your database (i.e. dw, production, staging)}

\item{filename}{filepath to SQLite db}

\item{dbtype}{the dbtype for your database (postgres, mysql, sqlite, or redshift)}

\item{profile}{the profile for your database (a connection profile)}
}
\description{
Returns a structure that helps you query and interact with your database.
}
\examples{
db <- DemoDB()
db$query("select * from Artist;")
db$tables
db$tables$Artist
db$tables$Artist$head()
db$tables$Artist$all()
db$tables$Artist$sample()
db$query("select * from Artist;")
db$find_table("A*")
db$find_column("*Id*")
\dontrun{
db <- db.new(username="kermit", password="rainbowconnection",
db$save_credentails(profile="muppetdb")

db <- db.new(profile="mysql_local")
db$query("select * from foo limit 10;")
}
}
\keyword{db,}
\keyword{new}
\keyword{object,}

