% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opentree_taxonomy.R
\name{check_ott_input}
\alias{check_ott_input}
\title{Check input for other functions}
\usage{
check_ott_input(input = NULL, ott_ids = NULL, ...)
}
\arguments{
\item{input}{Optional. A character vector of names or a \code{datelifeQuery} object.}

\item{ott_ids}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}.}

\item{...}{
  Arguments passed on to \code{\link[=make_datelife_query]{make_datelife_query}}
  \describe{
    \item{\code{use_tnrs}}{Whether to use Open Tree of Life's Taxonomic Name Resolution Service (TNRS)
to process input taxon names. Default to \code{TRUE}, it corrects misspellings and
taxonomic name variations with \code{\link[=tnrs_match]{tnrs_match()}}, a wrapper of \code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}}.}
    \item{\code{get_spp_from_taxon}}{Whether to search ages for all species belonging to a
given taxon or not. Default to \code{FALSE}. If \code{TRUE}, it must have same length as input.
If input is a newick string with some clades it will be converted to a \code{phylo}
object, and the order of \code{get_spp_from_taxon} will match \code{phy$tip.label}.}
  }}
}
\value{
A named numeric vector of valid Open Tree Taxonomy (OTT) ids.
}
\description{
\verb{check_ott_input is currently used in functions }\code{\link[=get_ott_clade]{get_ott_clade()}},
\code{\link[=get_ott_children]{get_ott_children()}}, and \code{\link[=get_otol_synthetic_tree]{get_otol_synthetic_tree()}}.
}
\details{
By default, it uses the \code{ott_id} argument if it is not NULL.
}
