% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_phylo.R
\name{summary_matrix_to_phylo}
\alias{summary_matrix_to_phylo}
\title{Go from a summary matrix to an ultrametric \code{phylo} object.}
\usage{
summary_matrix_to_phylo(
  summ_matrix,
  datelife_query = NULL,
  total_distance = TRUE,
  use = "mean",
  target_tree = NULL,
  ...
)
}
\arguments{
\item{summ_matrix}{Any summary patristic distance matrix, such as the ones obtained with \code{\link[=datelife_result_sdm_matrix]{datelife_result_sdm_matrix()}} or \code{\link[=datelife_result_median_matrix]{datelife_result_median_matrix()}}.}

\item{datelife_query}{A \code{datelifeQuery} object, usually an output of \code{\link[=make_datelife_query]{make_datelife_query()}}.}

\item{total_distance}{Boolean. If \code{TRUE} it will divide the matrix in half, if
\code{FALSE} it will take it as is.}

\item{use}{A character vector indicating what type of age to use for summary.
One of the following:
\describe{
\item{mean}{It will use the mean of the node age distributions.}
\item{min}{It will use the minimum age from the node age distributions.}
\item{max}{Choose this if you wanna be conservative; it will use the maximum
age from the node age distributions.}
}}

\item{target_tree}{A \code{phylo} object. Use this in case you want a particular
backbone for the output tree.}

\item{...}{
  Arguments passed on to \code{\link[=get_otol_synthetic_tree]{get_otol_synthetic_tree}}
  \describe{
    \item{\code{otol_version}}{Version of Open Tree of Life to use}
    \item{\code{resolve}}{Defaults to \code{TRUE}. Whether to resolve the tree at random or not.}
    \item{\code{input}}{Optional. A character vector of names or a \code{datelifeQuery} object}
    \item{\code{ott_ids}}{If not NULL, it takes this argument and ignores input. A
numeric vector of ott ids obtained with \code{\link[rotl:taxonomy_taxon_info]{rotl::taxonomy_taxon_info()}} or
\code{\link[rotl:tnrs_match_names]{rotl::tnrs_match_names()}} or \code{\link[=tnrs_match]{tnrs_match()}}}
  }}
}
\value{
An ultrametric phylo object.
}
\description{
Go from a summary matrix to an ultrametric \code{phylo} object.
}
\details{
It can take a regular patristic distance matrix, but there are simpler
methods for that implemented in \code{\link[=patristic_matrix_to_phylo]{patristic_matrix_to_phylo()}}.
}
