% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IPS.R
\encoding{UTF-8}
\name{load_ips}
\alias{load_ips}
\title{IPS - Amazon Social Progress Index}
\usage{
load_ips(dataset = "ips", raw_data, time_period, language = "eng")
}
\arguments{
\item{dataset}{A dataset name ("ips")}

\item{raw_data}{A \code{boolean} setting the return of raw or processed data}

\item{time_period}{A \code{numeric} indicating what years will the data be loaded in the format YYYY.}

\item{language}{A \code{string} that indicates in which language the data will be returned. Currently, only Portuguese and English are supported.}
}
\value{
A \code{tibble} with the selected data.
}
\description{
Loads information on the social and environmental performance of the Legal Amazon. Survey is done at the municipal level and data is available in 2014 and 2018. See \url{http://www.ipsamazonia.org.br/}
}
\examples{
\dontrun{
# download raw data from 2014
ips <- load_ips(dataset = 'ips', raw_data = TRUE, time_period = 2014)
}
}
