% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit_diff.R
\name{commit_diff}
\alias{commit_diff}
\title{Commit diff}
\usage{
commit_diff(diff_df, destination, verbose = FALSE)
}
\arguments{
\item{diff_df}{a data frame. Output off diffdfs::diffdfs.}

\item{destination}{a local directory path or an arrow SubTreeFileSystem}

\item{verbose}{TRUE /FALSE should the function be chatty?}
}
\value{
TRUE
}
\description{
Write a diff to a versioned dataset destination. Check that it was written correctly, otherwise return an error.
}
\examples{
temp_dir <- tempfile()
dir.create(temp_dir, recursive = TRUE)
df <- data.frame(a = 1:5, b = letters[1:5])
new_df <- data.frame(a = 2:5, b = letters[2:5])
diff <- diffdfs::diffdfs(new_df, df)

commit_diff(diff, temp_dir)

unlink(temp_dir)

}
