% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasetjson.R
\name{dataset_json}
\alias{dataset_json}
\title{Create a Dataset JSON Object}
\usage{
dataset_json(
  .data,
  item_id,
  name,
  label,
  items,
  dataset_meta,
  version = "1.0.0",
  data_type = c("clinicalData", "referenceData"),
  file_meta = file_metadata(),
  data_meta = data_metadata()
)
}
\arguments{
\item{.data}{Input data to contain within the Dataset JSON file. Written to
the itemData parameter.}

\item{item_id}{ID used to label dataset with the itemGroupData parameter.
Defined as "Object of Datasets. Key value is a unique identifier for
Dataset, corresponding to ItemGroupDef/@OID in Define-XML."}

\item{name}{Dataset name}

\item{label}{Dataset Label}

\item{items}{Variable metadata}

\item{dataset_meta}{A dataset_metadata object holding pre-specified
dataset metadata.}

\item{version}{Version of Dataset JSON schema to follow.}

\item{data_type}{Type of data being written. clinicalData for subject level
data, and referenceData for non-subject level data (i.e. TDMs, Associated
Persons)}

\item{file_meta}{A file_metadata object holding pre-specified file
metadata}

\item{data_meta}{A data_metadata object holding pre-specified data
metadata}
}
\value{
dataset_json object pertaining to the specific Dataset JSON version
specific
}
\description{
Create the base object used to write a Dataset JSON file.
}
\examples{
# Create a basic object
ds_json <- dataset_json(iris, "IG.IRIS", "IRIS", "Iris", iris_items)

# Attach attributes directly
ds_json_updated <- set_data_type(ds_json, "referenceData")
ds_json_updated <- set_file_oid(ds_json_updated, "/some/path")
ds_json_updated <- set_metadata_ref(ds_json_updated, "some/define.xml")
ds_json_updated <- set_metadata_version(ds_json_updated, "MDV.MSGv2.0.SDTMIG.3.3.SDTM.1.7")
ds_json_updated <- set_originator(ds_json_updated, "Some Org")
ds_json_updated <- set_source_system(ds_json_updated, "source system", "1.0")
ds_json_updated <- set_study_oid(ds_json_updated, "SOMESTUDY")

# Create independent objects for metadata sections first
file_meta <- file_metadata(
  originator = "Some Org",
  sys = "source system",
  sys_version = "1.0"
)

data_meta <- data_metadata(
  study = "SOMESTUDY",
  metadata_version = "MDV.MSGv2.0.SDTMIG.3.3.SDTM.1.7",
  metadata_ref = "some/define.xml"
)

dataset_meta <- dataset_metadata(
  item_id = "IG.IRIS",
  name = "IRIS",
  label = "Iris",
  items = iris_items
)

ds_json_from_meta <- dataset_json(
  iris,
  dataset_meta = dataset_meta,
  file_meta = file_meta,
  data_meta = data_meta
  )
}
