% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DeploymentAccuracy.R
\name{GetDeploymentAccuracyOverTime}
\alias{GetDeploymentAccuracyOverTime}
\title{Retrieves accuracy statistics over time on given metrics for a deployment.}
\usage{
GetDeploymentAccuracyOverTime(
  deploymentId,
  metrics,
  modelId = NULL,
  start = NULL,
  end = NULL,
  bucketSize = NULL,
  segmentAttribute = NULL,
  segmentValue = NULL
)
}
\arguments{
\item{deploymentId}{character. The ID of the deployment in question.}

\item{metrics}{character. Metrics to query. See \code{DeploymentAccuracyMetric} for supported
values.}

\item{modelId}{character. Optional. The ID of the model to query. If provided, only data for this
specific model will be retrieved; otherwise, data for the deployment's default model will be
retrieved.}

\item{start}{POSIXct. Optional. The start time of the reporting period for monitoring data.
Defaults to seven days prior to the end of the period. Sub-hour resolution is not permitted,
and the timezone must be \code{UTC}.}

\item{end}{POSIXct. Optional. The end time of the reporting period for monitoring data. Defaults
to the next top of the hour. Sub-hour resolution is not permitted, and the timezone must be
\code{UTC}.}

\item{bucketSize}{character. Optional. The time duration of a bucket. This should be a multiple
of one hour and cannot be longer than the total length of the period. If not set, a default
value will be calculated based on the \code{start} and \code{end} times.}

\item{segmentAttribute}{character. Optional. The name of an attribute used for segment analysis.
See SegmentAnalysisAttribute`` for permitted values. Added in DataRobot 2.21.}

\item{segmentValue}{character. Optional. The value of \code{segmentAttribute}. Added in DataRobot
2.21.}
}
\value{
An object representing how accuracy has changed over time for the deployment, containing:
\itemize{
\item modelId character. The ID of the deployment model for which monitoring data was
retrieved.
\item summary data.frame. A summary \code{bucket} across the entire reporting period.
\item buckets data.frame. A list of \code{buckets} representing each interval (constrained by
the \code{bucketSize} parameter) in the reporting period.
\item baseline data.frame. A baseline \code{bucket}.
}
Each \code{bucket} contains:
\itemize{
\item sampleSize. integer. The number of predictions made against this deployment.
\item start. POSIXct. The start time of the bucket. May be NA.
\item end. POSIXct. The end time of the bucket. May be NA.
\item \code{metricName}. numeric. Given N metrics queried, there will be N value columns, each
one named for the metric. See \code{DeploymentAccuracyMetric} for supported values. May be NA if
\code{sampleSize} is 0.
}
}
\description{
By default this will return statistics for the last seven days prior to the next; set the \code{start}
and \code{end} parameters to adjust the reporting period.
}
\examples{
\dontrun{
deploymentId <- "59a5af20c80891534e3c2bde"
aot <- GetDeploymentAccuracyOverTime(deploymentId,
         metrics = c(DeploymentAccuracyMetric$Gamma.Deviance,
                     DeploymentAccuracyMetric$LogLoss,
                     DeploymentAccuracyMetric$RMSE))
}
}
\seealso{
Other deployment accuracy functions: 
\code{\link{GetDeploymentAccuracy}()},
\code{\link{GetDeploymentAssociationId}()},
\code{\link{SubmitActuals}()}
}
\concept{deployment accuracy functions}
