% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnomalyAssessment.R
\name{InitializeAnomalyAssessment}
\alias{InitializeAnomalyAssessment}
\title{Request anomaly assessment insight computation on the specified subset.}
\usage{
InitializeAnomalyAssessment(
  projectId,
  modelId,
  backtest,
  source,
  seriesId = NULL
)
}
\arguments{
\item{projectId}{character. The ID of the project to compute insight for.}

\item{modelId}{character. The ID of the model to compute insight for.}

\item{backtest}{integer or "holdout". The backtest to compute insight for.}

\item{source}{"training" or "validation". The source to compute insight for.}

\item{seriesId}{character. Optional. The series id to compute insight for.
Required for multiseries projects.}
}
\value{
An object with anomaly assessment metadata:
\itemize{
\item recordId. character. The ID of the record.
\item projectId. character. The project ID of the record.
\item modelId. character. The model ID of the record.
\item backtest. character. The backtest of the record.
\item source. character. The source of the record.
\item seriesId. character. the series ID of the record.
\item status. character. The status of the insight.
\item statusDetails. character. The explanation of the status.
\item startDate. POSIXct. Timestamp of the first prediction in the subset. Will be NULL if
status is not \code{completed}.
\item endDate. POSIXct. Timestamp of the last prediction in the subset. Will be NULL
if status is not \code{completed}.
\item predictionThreshold. numeric. The threshold, all rows with anomaly scores greater or
equal to it have shap explanations computed. Will be NULL if status is not \code{completed}.
\item previewLocation. character. URL to retrieve predictions preview for the subset.
Will be NULL if status is not \code{completed}.
\item latestExplanationsLocation. character. the URL to retrieve the latest predictions with
the shap explanations. Will be NULL if status is not \code{completed}.
\item deleteLocation. character. the URL to delete anomaly assessment record and
relevant insight data.
}
}
\description{
Request anomaly assessment insight computation on the specified subset.
}
\examples{
\dontrun{
projectId <- "59a5af20c80891534e3c2bde"
modelId <- "59a5af20c80891534e3c2bdd"
record <- InitializeAnomalyAssessment(projectId, modelId, backtest=0, source="validation",
   seriesId="Baltimore")
}
}
\seealso{
Other Anomaly Assessment functions: 
\code{\link{DeleteAnomalyAssessmentRecord}()},
\code{\link{GetAnomalyAssessmentExplanations}()},
\code{\link{GetAnomalyAssessmentPredictionsPreview}()},
\code{\link{ListAnomalyAssessmentRecords}()}
}
\concept{Anomaly Assessment functions}
