% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictionExplanations.R
\name{DownloadPredictionExplanations}
\alias{DownloadPredictionExplanations}
\title{Function to download and save prediction explanations rows as csv file}
\usage{
DownloadPredictionExplanations(
  project,
  predictionExplanationId,
  filename,
  encoding = "UTF-8",
  excludeAdjustedPredictions = TRUE
)
}
\arguments{
\item{project}{character. Either (1) a character string giving the unique alphanumeric
identifier for the project, or (2) a list containing the element projectId with this
identifier.}

\item{predictionExplanationId}{character. Id of the prediction explanations.}

\item{filename}{character. Filename of file to save prediction explanations rows}

\item{encoding}{character. Optional. Character string A string representing the encoding
to use in the output file, defaults to 'UTF-8'.}

\item{excludeAdjustedPredictions}{logical. Optional. Set to FALSE to include adjusted
predictions, which are predictions adjusted by an exposure column. This is only relevant for
projects that use an exposure column.}
}
\value{
Logical TRUE and displays a message to the user if the delete
  request was successful; otherwise an error message is displayed.
}
\description{
Function to download and save prediction explanations rows as csv file
}
\examples{
\dontrun{
  projectId <- "59a5af20c80891534e3c2bde"
  modelId <- "5996f820af07fc605e81ead4"
  datasets <- ListPredictionDatasets(projectId)
  dataset <- datasets[[1]]
  datasetId <- dataset$id
  model <- GetModel(projectId, modelId)
  jobId <- RequestPredictionExplanations(model, datasetId)
  predictionExplanationId <- GetPredictionExplanationsMetadataFromJobId(projectId, jobId)$id
  file <- file.path(tempdir(), "testPredictionExplanation.csv")
  DownloadPredictionExplanations(projectId, predictionExplanationId, file)
}
}
