% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partitions.R
\name{CreateDatetimePartitionSpecification}
\alias{CreateDatetimePartitionSpecification}
\title{Create a list describing datetime partition parameters}
\usage{
CreateDatetimePartitionSpecification(datetimePartitionColumn,
  autopilotDataSelectionMethod = NULL, validationDuration = NULL,
  holdoutStartDate = NULL, holdoutDuration = NULL,
  disableHoldout = NULL, gapDuration = NULL,
  numberOfBacktests = NULL, backtests = NULL, useTimeSeries = FALSE,
  defaultToKnownInAdvance = FALSE, featureDerivationWindowStart = NULL,
  featureDerivationWindowEnd = NULL, featureSettings = NULL,
  treatAsExponential = NULL, differencingMethod = NULL,
  windowsBasisUnit = NULL, periodicities = NULL,
  forecastWindowStart = NULL, forecastWindowEnd = NULL,
  multiseriesIdColumns = NULL, useCrossSeries = NULL,
  aggregationType = NULL, crossSeriesGroupByColumns = NULL,
  calendar = NULL)
}
\arguments{
\item{datetimePartitionColumn}{character. The name of the column whose values as dates
are used to assign a row to a particular partition}

\item{autopilotDataSelectionMethod}{character. Optional. Whether models created
by the autopilot should use "rowCount" or "duration" as their dataSelectionMethod}

\item{validationDuration}{character. Optional. The default validationDuration for the
backtests}

\item{holdoutStartDate}{character. The start date of holdout scoring data
(RFC 3339 format). If holdoutStartDate is specified, holdoutDuration must also be specified.}

\item{holdoutDuration}{character. Optional. The duration of the holdout scoring data.
If holdoutDuration is specified, holdoutStartDate must also be specified.}

\item{disableHoldout}{logical. Optional. Whether to suppress allocating the holdout fold.
If set to TRUE, holdoutStartDate and holdoutDuration must not be specified.}

\item{gapDuration}{character. Optional. The duration of the gap between training and
holdout scoring data.}

\item{numberOfBacktests}{integer. The number of backtests to use.}

\item{backtests}{list. List of BacktestSpecification the exact specification of backtests to use.
The indexes of the specified backtests should range from 0 to numberOfBacktests - 1.
If any backtest is left unspecified, a default configuration will be chosen.}

\item{useTimeSeries}{logical. Whether to create a time series project (if TRUE) or an OTV
project which uses datetime partitioning (if FALSE). The default behavior is to create an
OTV project.}

\item{defaultToKnownInAdvance}{logical. Whether to default to treating features as known in
advance. Defaults to FALSE. Only used for time series project. Known in advance features are
expected to be known for dates in the future when making predictions (e.g., "is this a
holiday").}

\item{featureDerivationWindowStart}{integer. Optional. Offset into the past to define how far
back relative to the forecast point the feature derivation window should start. Only used for
time series projects. Expressed in terms of the \code{timeUnit} of the
\code{datetimePartitionColumn}.}

\item{featureDerivationWindowEnd}{integer. Optional. Offset into the past to define how far
back relative to the forecast point the feature derivation window should end. Only used for
time series projects. Expressed in terms of the \code{timeUnit} of the
\code{datetimePartitionColumn}.}

\item{featureSettings}{list. Optional. A list specifying settings for each feature. For each
feature you would like to set feature settings for, pass the following in a list:
\itemize{
  \item featureName character. The name of the feature to set feature settings.
  \item knownInAdvance logical. Optional. Whether or not the feature is known in advance.
    Used for time series only. Defaults to \code{FALSE}.
  \item doNotDerive logical. Optional. If \code{TRUE}, no time series derived features
    (e.g., lags) will be automatically engineered from this feature. Used for time series only.
    Defaults to \code{FALSE}.
}}

\item{treatAsExponential}{character. Optional. Defaults to "auto". Used to specify whether to
treat data as exponential trend and apply transformations like log-transform. Use values
from \code{TreatAsExponential} enum.}

\item{differencingMethod}{character. Optional. Defaults to "auto". Used to specify differencing
method to apply if data is stationary. Use values from \code{DifferencingMethod}.}

\item{windowsBasisUnit}{character. Optional. Indicates which unit is the basis for the feature
derivation window and forecast window. Valid options are a time unit (see \code{TimeUnit})
or "ROW".}

\item{periodicities}{list. Optional. A list of periodicities for different times. Must be
specified as a list of lists, where each list item specifies the `timeSteps` for a
particular `timeUnit`. Should be "ROW" if \code{windowsBasisUnit} is "ROW".}

\item{forecastWindowStart}{integer. Optional. Offset into the future to define how far forward
relative to the forecast point the forecast window should start. Only used for time series
projects. Expressed in terms of the \code{timeUnit} of the \code{datetimePartitionColumn}.}

\item{forecastWindowEnd}{integer. Optional. Offset into the future to define how far forward
relative to the forecast point the forecast window should end. Only used for time series
projects. Expressed in terms of the \code{timeUnit} of the \code{datetimePartitionColumn}.}

\item{multiseriesIdColumns}{list. A list of the names of multiseries id columns to define series}

\item{useCrossSeries}{logical. If \code{TRUE}, cross series features will be included. For
details, see "Calculating features across series" in the Time Series section of the
DataRobot user guide.}

\item{aggregationType}{character. Optional. The aggregation type to apply when creating cross
series features. Must be either "total" or "average". See \code{SeriesAggregationType}.}

\item{crossSeriesGroupByColumns}{character. Optional. Column to split a cross series into
further groups. For example, if every series is sales of an individual product, the cross
series group could be e product category with values like "men's clothing", "sports
equipment", etc. Requires multiseries with \code{useCrossSeries} enabled.}

\item{calendar}{character. Optional. Either the calendar object or calendar id to use
for this project.}
}
\value{
An S3 object of class 'partition' including the parameters required by the
  SetTarget function to generate a datetime partitioning of the modeling dataset.
}
\description{
Uniquely defines a DatetimePartitioning for some project
}
\details{
Includes only the attributes of DatetimePartitioning that are directly controllable by users,
not those determined by the DataRobot application based on the project dataset and the
user-controlled settings.
This is the specification that should be passed to SetTarget via the
partition parameter.  To see the full partitioning based on the project dataset,
GenerateDatetimePartition.
All durations should be specified with a duration string such as those returned
by the ConstructDurationString helper function.
}
\examples{
CreateDatetimePartitionSpecification("date_col")
CreateDatetimePartitionSpecification("date",
                                     featureSettings = list(
                                       list("featureName" = "Product_offers",
                                            "defaultToKnownInAdvance" = TRUE)))
partition <- CreateDatetimePartitionSpecification("dateColumn",
                                                treatAsExponential = TreatAsExponential$Always,
                                                differencingMethod = DifferencingMethod$Seasonal,
                                                periodicities = list(list("timeSteps" = 10,
                                                                          "timeUnit" = "HOUR"),
                                                                     list("timeSteps" = 600,
                                                                          "timeUnit" = "MINUTE"),
                                                                     list("timeSteps" = 7,
                                                                          "timeUnit" = "DAY")))
}
