% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Sharing.R
\name{UpdateAccess}
\alias{UpdateAccess}
\title{Update access to a particular object.}
\usage{
UpdateAccess(object, access)
}
\arguments{
\item{object}{object. The shared object to inspect access for.}

\item{access}{dataRobotAccessList. A list specifying access given to all users. See
\code{ListSharingAccess}.}
}
\description{
Update access to a particular object.
}
\examples{
\dontrun{
 dataStoreId <- "5c1303269300d900016b41a7"
 dataStore <- GetDataStore(dataStoreId)
 access <- ListSharingAccess(dataStore) 
 # Remove access from the first user and grant it to foo@foo.com instead.
 access[[1]]$username <- "foo@foo.com"
 UpdateAccess(dataStore, access)
 # Change access to a Read Only role.
 access[[1]]$role <- SharingRole$ReadOnly
 UpdateAccess(dataStore, access)
}
}
