% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/int_all_datastructure_dataframe.R
\name{int_all_datastructure_dataframe}
\alias{int_all_datastructure_dataframe}
\title{Wrapper function to check for studies data structure}
\usage{
int_all_datastructure_dataframe(
  meta_data_dataframe = "dataframe_level",
  meta_data = "item_level"
)
}
\arguments{
\item{meta_data_dataframe}{\link{data.frame} the data frame that contains the metadata for the data frame level, mandatory}

\item{meta_data}{\link{data.frame} the data frame that contains metadata attributes of the study data, mandatory. The metadata data frame is assumed to contain the  information from all the studies.
this is needed to know the \code{VAR_NAMES}, i.e., the column names used in data frames and  known from the metadata.}
}
\value{
a \link{list} with
\itemize{
\item \code{DataframeTable}: data frame with selected check results, used for the data quality report.
}
}
\description{
This function tests for unexpected elements and records, as well as duplicated identifiers and content.
The unexpected element record check can be conducted by providing the number of expected records or
an additional table with the expected records.
It is possible to conduct the checks by study segments or to consider only selected
segments.
}
\examples{
\dontrun{
out_dataframe <- int_all_datastructure_dataframe(
  meta_data_dataframe = "meta_data_dataframe",
  meta_data = "ship_meta"
)
md0 <- prep_get_data_frame("ship_meta")
md0
md0$VAR_NAMES
md0$VAR_NAMES[[1]] <- "Id" # is this missmatch reported -- is the data frame
                           # also reported, if nothing is wrong with it
out_dataframe <- int_all_datastructure_dataframe(
  meta_data_dataframe = "meta_data_dataframe",
  meta_data = md0
)

# This is the "normal" procedure for inside pipeline
# but outside this function  checktype is exact by default
options(dataquieR.RECORD_MISSMATCH_CHECKTYPE = "subset_u")
lapply(setNames(nm = prep_get_data_frame("meta_data_dataframe")$DF_NAME),
  int_sts_element_dataframe, meta_data = md0)
md0$VAR_NAMES[[1]] <-
  "id" # is this missmatch reported -- is the data frame also reported,
       # if nothing is wrong with it
lapply(setNames(nm = prep_get_data_frame("meta_data_dataframe")$DF_NAME),
  int_sts_element_dataframe, meta_data = md0)
options(dataquieR.RECORD_MISSMATCH_CHECKTYPE = "exact")
}

}
