/*
 * Decompiled with CFR 0.152.
 */
package org.dspace.foresite.atom;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.sun.syndication.feed.WireFeed;
import com.sun.syndication.feed.atom.Category;
import com.sun.syndication.feed.atom.Content;
import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import com.sun.syndication.feed.atom.Generator;
import com.sun.syndication.feed.atom.Link;
import com.sun.syndication.feed.atom.Person;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.WireFeedOutput;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.dspace.foresite.Agent;
import org.dspace.foresite.AggregatedResource;
import org.dspace.foresite.Aggregation;
import org.dspace.foresite.OREException;
import org.dspace.foresite.ORESerialiser;
import org.dspace.foresite.ORESerialiserException;
import org.dspace.foresite.ORESerialiserFactory;
import org.dspace.foresite.Proxy;
import org.dspace.foresite.ReMSerialisation;
import org.dspace.foresite.ResourceMap;
import org.dspace.foresite.ResourceMapDocument;
import org.dspace.foresite.Triple;
import org.dspace.foresite.TripleSelector;
import org.dspace.foresite.jena.AggregationJena;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomORESerialiser
implements ORESerialiser {
    public static Namespace rdfNS = Namespace.getNamespace((String)"rdf", (String)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");

    @Override
    public void configure(Properties properties) {
    }

    @Override
    public ResourceMapDocument serialiseRaw(ResourceMap rem) throws ORESerialiserException {
        return null;
    }

    @Override
    public ResourceMapDocument serialise(ResourceMap resourceMap) throws ORESerialiserException {
        try {
            ResourceMap rem = resourceMap.copy();
            Aggregation agg = rem.getAggregation();
            URI uri_r = rem.getURI();
            URI uri_a = agg.getURI();
            Feed atom = new Feed("atom_1.0");
            ArrayList<Entry> entries = new ArrayList<Entry>();
            ArrayList<Link> relateds = new ArrayList<Link>();
            ArrayList<Link> alternates = new ArrayList<Link>();
            ArrayList foreign = new ArrayList();
            ArrayList<Category> cats = new ArrayList<Category>();
            ArrayList<Person> contribs = new ArrayList<Person>();
            atom.setId(uri_a.toString());
            List<URI> similarTo = agg.getSimilarTo();
            for (URI similar : similarTo) {
                Link link = new Link();
                link.setRel("related");
                link.setHref(similar.toString());
                TripleSelector typeSel = new TripleSelector(similar, new URI(DC.format.getURI()), null);
                TripleSelector langSel = new TripleSelector(similar, new URI(DC.language.getURI()), null);
                TripleSelector titleSel = new TripleSelector(similar, new URI(DC.title.getURI()), null);
                List<Triple> typeT = agg.listAllTriples(typeSel);
                List<Triple> langT = agg.listAllTriples(langSel);
                List<Triple> titleT = agg.listAllTriples(titleSel);
                if (typeT != null && typeT.size() > 0) {
                    Triple typeTriple = typeT.get(0);
                    link.setType(typeTriple.isLiteral() ? typeTriple.getObjectLiteral() : typeTriple.getObjectURI().toString());
                    agg.removeTriple(typeTriple);
                }
                if (langT != null && langT.size() > 0) {
                    Triple langTriple = langT.get(0);
                    link.setHreflang(langTriple.isLiteral() ? langTriple.getObjectLiteral() : langTriple.getObjectURI().toString());
                    agg.removeTriple(langTriple);
                }
                if (titleT != null && titleT.size() > 0) {
                    Triple titleTriple = titleT.get(0);
                    link.setTitle(titleTriple.isLiteral() ? titleTriple.getObjectLiteral() : titleTriple.getObjectURI().toString());
                    agg.removeTriple(titleTriple);
                }
                relateds.add(link);
            }
            agg.clearSimilarTo();
            List<ReMSerialisation> otherRems = agg.getReMSerialisations();
            for (ReMSerialisation serial : otherRems) {
                if (!serial.getURI().equals(uri_r)) {
                    Link link = new Link();
                    link.setRel("alternate");
                    link.setHref(serial.getURI().toString());
                    TripleSelector typeSel = new TripleSelector(serial.getURI(), new URI(DC.format.getURI()), null);
                    TripleSelector langSel = new TripleSelector(serial.getURI(), new URI(DC.language.getURI()), null);
                    TripleSelector titleSel = new TripleSelector(serial.getURI(), new URI(DC.title.getURI()), null);
                    List<Triple> typeT = agg.listAllTriples(typeSel);
                    List<Triple> langT = agg.listAllTriples(langSel);
                    List<Triple> titleT = agg.listAllTriples(titleSel);
                    if (typeT != null && typeT.size() > 0) {
                        Triple typeTriple = typeT.get(0);
                        link.setType(typeTriple.isLiteral() ? typeTriple.getObjectLiteral() : typeTriple.getObjectURI().toString());
                        agg.removeTriple(typeTriple);
                    }
                    if (langT != null && langT.size() > 0) {
                        Triple langTriple = langT.get(0);
                        link.setHreflang(langTriple.isLiteral() ? langTriple.getObjectLiteral() : langTriple.getObjectURI().toString());
                        agg.removeTriple(langTriple);
                    }
                    if (titleT != null && titleT.size() > 0) {
                        Triple titleTriple = titleT.get(0);
                        link.setTitle(titleTriple.isLiteral() ? titleTriple.getObjectLiteral() : titleTriple.getObjectURI().toString());
                        agg.removeTriple(titleTriple);
                    }
                    alternates.add(link);
                }
                agg.clearReMSerialisations();
            }
            List<URI> rights = agg.getRights();
            for (URI right : rights) {
                Link link = new Link();
                link.setRel("license");
                link.setHref(right.toString());
                TripleSelector typeSel = new TripleSelector(right, new URI(DC.format.getURI()), null);
                TripleSelector langSel = new TripleSelector(right, new URI(DC.language.getURI()), null);
                TripleSelector titleSel = new TripleSelector(right, new URI(DC.title.getURI()), null);
                List<Triple> typeT = agg.listAllTriples(typeSel);
                List<Triple> langT = agg.listAllTriples(langSel);
                List<Triple> titleT = agg.listAllTriples(titleSel);
                if (typeT != null && typeT.size() > 0) {
                    Triple typeTriple = typeT.get(0);
                    link.setType(typeTriple.isLiteral() ? typeTriple.getObjectLiteral() : typeTriple.getObjectURI().toString());
                    agg.removeTriple(typeTriple);
                }
                if (langT != null && langT.size() > 0) {
                    Triple langTriple = langT.get(0);
                    link.setHreflang(langTriple.isLiteral() ? langTriple.getObjectLiteral() : langTriple.getObjectURI().toString());
                    agg.removeTriple(langTriple);
                }
                if (titleT != null && titleT.size() > 0) {
                    Triple titleTriple = titleT.get(0);
                    link.setTitle(titleTriple.isLiteral() ? titleTriple.getObjectLiteral() : titleTriple.getObjectURI().toString());
                    agg.removeTriple(titleTriple);
                }
                alternates.add(link);
            }
            agg.clearRights();
            Link self = new Link();
            self.setRel("self");
            self.setHref(uri_r.toString());
            relateds.add(self);
            atom.setIcon("http://www.openarchives.org/ore/favicon.ico");
            List<Agent> remCreators = rem.getCreators();
            if (remCreators != null && !remCreators.isEmpty()) {
                Agent creator = remCreators.get(0);
                Generator generator = new Generator();
                List<String> names = creator.getNames();
                URI creatorURI = creator.getURI();
                StringBuilder sb = new StringBuilder();
                for (String name : names) {
                    sb.append(name + " ");
                }
                generator.setValue(sb.toString());
                if (creatorURI != null) {
                    generator.setUrl(creatorURI.toString());
                }
                atom.setGenerator(generator);
            }
            List<Agent> contributors = agg.getAgents(new URI(DC.contributor.getURI()));
            for (Agent contributor : contributors) {
                List<String> names = contributor.getNames();
                List<URI> mboxes = contributor.getMboxes();
                URI uri = contributor.getURI();
                Person contrib = new Person();
                StringBuilder sb = new StringBuilder();
                for (String name : names) {
                    sb.append(name + " ");
                }
                contrib.setName(sb.toString());
                if (uri != null) {
                    contrib.setUrl(uri.toString());
                }
                if (mboxes != null) {
                    contrib.setEmail(mboxes.get(0).toString());
                }
                contribs.add(contrib);
            }
            atom.setContributors(contribs);
            TripleSelector subTitleSel = new TripleSelector(uri_a, new URI(DC.description.getURI()), null);
            List<Triple> subTriples = agg.listAllTriples(subTitleSel);
            if (subTriples != null) {
                Content subtitle = new Content();
                subtitle.setValue(subTriples.get(0).getObjectLiteral());
                atom.setSubtitle(subtitle);
                agg.removeTriple(subTriples.get(0));
            }
            Date modified = rem.getModified();
            atom.setUpdated(modified);
            rem.removeModified();
            String remRights = rem.getRights();
            atom.setRights(remRights);
            rem.removeRights();
            List<Agent> agents = agg.getCreators();
            ArrayList<Person> authors = new ArrayList<Person>();
            for (Agent agent : agents) {
                Person author = new Person();
                List<String> names = agent.getNames();
                List<URI> mboxes = agent.getMboxes();
                URI uri = agent.getURI();
                for (String name : names) {
                    author.setName(name);
                }
                for (URI mbox : mboxes) {
                    author.setEmail(mbox.toString());
                }
                if (uri != null) {
                    author.setUri(uri.toString());
                }
                authors.add(author);
            }
            atom.setAuthors(authors);
            agg.clearCreators();
            List<URI> types = agg.getTypes();
            for (URI type : types) {
                Category category = new Category();
                category.setTerm(type.toString());
                if (type.toString().equals("http://www.openarchives.org/ore/terms/Aggregation")) {
                    category.setScheme("http://www.openarchives.org/ore/terms/");
                    category.setLabel("Aggregation");
                } else {
                    TripleSelector schemeSel;
                    List<Triple> schemes;
                    TripleSelector labelSel = new TripleSelector(type, new URI(RDFS.label.getURI()), null);
                    List<Triple> labels = agg.listAllTriples(labelSel);
                    if (labels != null && labels.size() > 0) {
                        category.setLabel(labels.get(0).getObjectLiteral());
                        agg.removeTriple(labels.get(0));
                    }
                    if ((schemes = agg.listAllTriples(schemeSel = new TripleSelector(type, new URI(RDFS.isDefinedBy.getURI()), null))) != null && schemes.size() > 0) {
                        category.setScheme(schemes.get(0).getObjectURI().toString());
                        agg.removeTriple(schemes.get(0));
                    }
                }
                cats.add(category);
            }
            agg.clearTypes();
            atom.setCategories(cats);
            List<String> titles = agg.getTitles();
            if (titles != null && !titles.isEmpty()) {
                atom.setTitle(titles.get(0));
                titles.remove(0);
                agg.setTitles(titles);
            }
            List<AggregatedResource> ars = agg.getAggregatedResources();
            for (AggregatedResource ar : ars) {
                Entry entry = this.atomEntry(ar);
                entries.add(entry);
            }
            agg.clearAggregatedResources();
            List<Element> rdf = this.getTopLevelRDF(rem);
            if (rdf != null) {
                atom.setForeignMarkup(rdf);
            }
            atom.setOtherLinks(relateds);
            atom.setAlternateLinks(alternates);
            atom.setEntries(entries);
            StringWriter writer = new StringWriter();
            WireFeedOutput output = new WireFeedOutput();
            output.output((WireFeed)atom, (Writer)writer);
            ResourceMapDocument rmd = new ResourceMapDocument();
            rmd.setSerialisation(writer.toString());
            rmd.setMimeType("application/atom+xml");
            rmd.setUri(uri_r);
            return rmd;
        }
        catch (OREException e) {
            throw new ORESerialiserException(e);
        }
        catch (IOException e) {
            throw new ORESerialiserException(e);
        }
        catch (FeedException e) {
            throw new ORESerialiserException(e);
        }
        catch (URISyntaxException e) {
            throw new ORESerialiserException(e);
        }
    }

    private List<Element> getAggregationRDF(Aggregation agg) throws OREException {
        Element aggElement = new Element("Description", rdfNS);
        aggElement.setAttribute("about", agg.getURI().toString());
        List<Triple> triples = agg.listTriples();
        Model model = ModelFactory.createDefaultModel();
        Resource resource = model.createResource(agg.getURI().toString());
        Model original = ((AggregationJena)agg).getModel();
        return null;
    }

    private List<Element> getReMRDF(ResourceMap rem) throws OREException {
        List<Triple> remTriples = rem.listTriples();
        Element remElement = new Element("Description", rdfNS);
        remElement.setAttribute("about", rem.getURI().toString());
        for (Triple triple : remTriples) {
        }
        return null;
    }

    private List<Element> getTopLevelRDF(ResourceMap rem) throws OREException {
        try {
            ORESerialiser serial = ORESerialiserFactory.getInstance("RDF/XML");
            ResourceMapDocument rmd = serial.serialiseRaw(rem);
            String rdfxml = rmd.getSerialisation();
            ByteArrayInputStream is = new ByteArrayInputStream(rdfxml.getBytes());
            SAXBuilder builder = new SAXBuilder();
            Document document = builder.build((InputStream)is);
            Element root = document.getRootElement();
            List children = root.getChildren();
            ArrayList<Element> detached = new ArrayList<Element>();
            for (int i = 0; i < children.size(); ++i) {
                detached.add((Element)((Element)children.get(i)).detach());
            }
            return detached;
        }
        catch (ORESerialiserException e) {
            throw new OREException(e);
        }
        catch (JDOMException e) {
            throw new OREException(e);
        }
        catch (IOException e) {
            throw new OREException(e);
        }
    }

    private List<Element> getEntryRDF(AggregatedResource ar) throws OREException {
        return null;
    }

    private Entry atomEntry(AggregatedResource ar) throws OREException {
        Entry entry = new Entry();
        ArrayList<Link> entryAlt = new ArrayList<Link>();
        ArrayList<Link> entryOther = new ArrayList<Link>();
        ArrayList<Category> categories = new ArrayList<Category>();
        Proxy proxy = ar.getProxy();
        if (proxy != null) {
            entry.setId(proxy.getURI().toString());
            URI lineage = proxy.getLineage();
            if (lineage != null) {
                Link link = new Link();
                link.setRel("via");
                link.setHref(lineage.toString());
                entryOther.add(link);
            }
        }
        Link alt = new Link();
        alt.setRel("alternate");
        alt.setHref(ar.getURI().toString());
        entryAlt.add(alt);
        List<Agent> agents = ar.getCreators();
        ArrayList<Person> authors = new ArrayList<Person>();
        if (agents != null) {
            for (Agent agent : agents) {
                Person author = new Person();
                List<String> names = agent.getNames();
                List<URI> mboxes = agent.getMboxes();
                URI uri = agent.getURI();
                for (String name : names) {
                    author.setName(name);
                }
                for (URI mbox : mboxes) {
                    author.setEmail(mbox.toString());
                }
                author.setUri(uri.toString());
                authors.add(author);
            }
        }
        entry.setAuthors(authors);
        ar.clearCreators();
        List<URI> types = ar.getTypes();
        for (URI type : types) {
            Category category = new Category();
            category.setTerm(type.toString());
            categories.add(category);
        }
        entry.setCategories(categories);
        List<URI> otherAggs = ar.getAggregations();
        for (URI other : otherAggs) {
            Link link = new Link();
            link.setRel("related");
            link.setHref(other.toString());
            entryOther.add(link);
        }
        List<Element> arElements = this.getEntryRDF(ar);
        entry.setAlternateLinks(entryAlt);
        entry.setOtherLinks(entryOther);
        entry.setCategories(categories);
        entry.setForeignMarkup(arElements);
        return entry;
    }
}

