% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_party_by_id.R
\name{get_party_by_id}
\alias{get_party_by_id}
\title{Download Information About a Party on Databrary as JSON}
\usage{
get_party_by_id(
  party_id = 6,
  parents_children_access = TRUE,
  vb = options::opt("vb"),
  rq = NULL
)
}
\arguments{
\item{party_id}{An integer. The party number to retrieve information about.}

\item{parents_children_access}{A logical value. If TRUE (the default),
returns \emph{all} of the data about the party. If FALSE, only a minimum amount
of information about the party is returned.}

\item{vb}{Show verbose messages. (Defaults to \code{FALSE}, overwritable using option 'databraryr.vb' or environment variable 'R_DATABRARYR_VB')}

\item{rq}{An \code{httr2}-style request object. If NULL, then a new request will
be generated using \code{make_default_request()}.}
}
\value{
A nested list with information about the party.
This can be readily parsed by other functions.
}
\description{
Download Information About a Party on Databrary as JSON
}
\examples{
\donttest{
\dontrun{
get_party_by_id()
}
}
}
