% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale.R
\name{fast_scale}
\alias{fast_scale}
\title{scale}
\usage{
fast_scale(data_set, scales = NULL, way = "scale", verbose = TRUE)
}
\arguments{
\item{data_set}{Matrix, data.frame or data.table}

\item{scales}{Result of function \code{\link{build_scales}}, (list, default to NULL). \cr
To perform the same scaling on train and test, it is recommended to compute \code{\link{build_scales}}
before. If it is kept to NULL, build_scales will be called.}

\item{way}{should scaling or unscaling be performed? (character either "scale" or "unscale", default to "scale")}

\item{verbose}{Should the algorithm talk? (Logical, default to TRUE)}
}
\value{
\code{data_set} with columns scaled (or unscaled) by \strong{reference}. Scaled means that each
 column mean will be 0 and each column standard deviation will be 1.
}
\description{
Perform efficient scaling on a data set.
}
\details{
Scaling numeric values is useful for some machine learning algorithm such as
 logistic regression or neural networks. \cr
 Unscaling numeric values can be very useful for most post-model analysis to do so set way to "unscale". \cr
This implementation of scale will be faster that \code{\link{scale}} for large data sets.
}
\examples{
# Load data
data(adult)

# compute scales
scales <- build_scales(adult, cols = "auto", verbose = TRUE)

# Scale data set
adult <- fast_scale(adult, scales = scales, verbose = TRUE)

# Control
print(mean(adult$age)) # Almost 0
print(sd(adult$age)) # 1

# To unscale it:
adult <- fast_scale(adult, scales = scales, way = "unscale", verbose = TRUE)

# Control
print(mean(adult$age)) # About 38.6
print(sd(adult$age)) # About 13.6
}
