% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreateTheme_shinyDashboardThemes.R
\name{shinyDashboardThemes}
\alias{shinyDashboardThemes}
\title{shinyDashboardThemes}
\usage{
shinyDashboardThemes(theme)
}
\arguments{
\item{theme}{String. Name of theme to be used}
}
\value{
CSS code. Theme for shinydashboard.
}
\description{
Calls a custom theme object created using shinyDashboardThemeDIY
}
\section{Available themes}{

\itemize{
  \item \strong{blue_gradient}: Demonstrates use of gradients, shadows and rounded corners.
  \item \strong{flat_red}: Flat colour theme with red highlights.
  \item \strong{grey_light}: Lightweight grey theme.
  \item \strong{grey_dark}: Demonstrates use of inverted dark colour schemes.
  \item \strong{onenote}: Styled similarly to the OneNote application.
  \item \strong{poor_mans_flatly}: Poor man`s version of the
  \href{https://bootswatch.com/flatly/}{Flatly} theme.
  \item \strong{purple_gradient}: Demonstrates use of dark gradients and rounded corners.
}
}

\examples{
\donttest{
#...
### ui body
#dashboardBody(

  ### changing theme
  shinyDashboardThemes(
    theme = "blue_gradient"
  )

  ### ui tabs
  #,tabItems(
  #  tabItem(
  #    ...
}
}
\seealso{
\code{\link{shinyDashboardThemeDIY}, \link{shinyDashboardLogo}}
}
