% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.pcoa.plot.r
\name{gl.pcoa.plot}
\alias{gl.pcoa.plot}
\title{Bivariate plot of the results of an ordination generated using gl.pcoa()}
\usage{
gl.pcoa.plot(
  glPca,
  x,
  scale = FALSE,
  ellipse = FALSE,
  p = 0.95,
  labels = "pop",
  theme_plot = 4,
  as.pop = NULL,
  hadjust = 1.5,
  vadjust = 1,
  xaxis = 1,
  yaxis = 2,
  plot.out = TRUE,
  verbose = NULL
)
}
\arguments{
\item{glPca}{Name of the PCA or PCoA object containing the factor scores and eigenvalues [required]}

\item{x}{Name of the genlight object or fd object containing the SNP genotypes or 
a genlight object containing the Tag P/A (SilicoDArT) genotypes or 
the Distance Matrix used to generate the ordination [required]}

\item{scale}{Flag indicating whether or not to scale the x and y axes in proportion to \% variation explained [default FALSE]}

\item{ellipse}{Flag to indicate whether or not to display ellipses to encapsulate points for each population [default FALSE]}

\item{p}{Value of the percentile for the ellipse to encapsulate points for each population [default 0.95]}

\item{labels}{Flag to specify the labels are to be added to the plot. ["none"|"ind"|"pop"|"interactive"|"legend", default = "pop"]}

\item{theme_plot}{Theme for the plot. See Details for options [default 4]}

\item{as.pop}{-- assign another metric to represent populations for the plot [default NULL]}

\item{hadjust}{Horizontal adjustment of label position [default 1.5]}

\item{vadjust}{Vertical adjustment of label position [default 1]}

\item{xaxis}{Identify the x axis from those available in the ordination (xaxis <= nfactors)}

\item{yaxis}{Identify the y axis from those available in the ordination (yaxis <= nfactors)}

\item{plot.out}{If TRUE, returns a plot object compatable with ggplot, otherwise returns a dataframe [default TRUE]}

\item{verbose}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2 or as specified using gl.set.verbosity]}
}
\value{
A plot of the ordination [plot.out=TRUE] or a dataframe [plot.out=FALSE]
}
\description{
This script takes output from the ordination generated by gl.pcoa() and plots the individuals classified by population.
}
\details{
The factor scores are taken from the output of gl.pcoa() and the population assignments are taken from
from the original data file. The specimens are shown in a bivariate plot optionally with adjacent labels
and enclosing ellipses. Population labels on the plot are shuffled so as not to overlap (using package \{directlabels\}).
This can be a bit clunky, as the labels may be some distance from the points to which they refer, but it provides the
opportunity for moving labels around using graphics software (e.g. Adobe Illustrator).

Any pair of axes can be specified from the ordination, provided they are within the range of the nfactors value provided to gl.pcoa(). Axes can be scaled to
represent the proportion of variation explained. In any case, the proportion of variation explained by each axis is provided in the axis label.

Points displayed in the ordination can be identified if the option labels="interactive" is chosen, in which case the resultant plot is
ggplotly() friendly. Identification of points is by moving the mouse
over them. Refer to the plotly package for further information. 

If plot.out=TRUE, returns an object of class ggplot so that layers can subsequently be added; if plot.out=FALSE, returns a dataframe
with the individual labels, population labels and PCOA scores for subsequent plotting by the user with ggplot or other plotting software. 

The themes available to format the plot are the following:
theme_minimal[1], theme_classic[2],theme_bw[3],theme_gray[4],theme_linedraw[5],theme_light[6],theme_dark[7],theme_economist[8],theme_economist_white[9],theme_calc[10],theme_clean[11],theme_excel[12],theme_excel_new[13],theme_few[14],theme_fivethirtyeight[15],theme_foundation[16],theme_gdocs[17],theme_hc[18],theme_igray[19],theme_solarized[20],theme_solarized_2[21],theme_solid[22],theme_stata[23],theme_tufte[24],theme_wsj[25]
Examples of these themes can be consulted in 
\url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
}
\examples{
if (requireNamespace("directlabels", quietly = TRUE)) {
gl <- testset.gl
levels(pop(gl))<-c(rep("Coast",5),rep("Cooper",3),rep("Coast",5),
rep("MDB",8),rep("Coast",7),"Em.subglobosa","Em.victoriae")
pca<-gl.pcoa(gl,nfactors=5)
gl.pcoa.plot(pca, gl, ellipse=TRUE, p=0.99, labels="pop",hadjust=1.5,
 vadjust=1)
if (requireNamespace("plotly", quietly = TRUE)) {
#interactive plot to examine labels
gl.pcoa.plot(pca, gl, labels="interactive")  
}
}
}
\author{
Arthur Georges (Post to \url{https://groups.google.com/d/forum/dartr})
}
