% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.write.csv.r
\name{gl.write.csv}
\alias{gl.write.csv}
\title{Write out data from a gl object \link{adegenet} to csv file}
\usage{
gl.write.csv(gl, outfile = "outfile.csv", outpath = tempdir())
}
\arguments{
\item{gl}{-- name of the genlight object containing SNP genotypes [required]}

\item{outfile}{-- name of the csv file to write the data to [required]}

\item{outpath}{-- path where to save the output file (set to tempdir by default)}
}
\value{
saves a glenlight object to csv
}
\description{
This script writes to file the SNP genotypes with specimens as entities (columns) and
loci as attributes (rows). Each row has associated locus metadata. Each column, with header
of specimen id, has population in the first row.
}
\details{
The data coding differs from the DArT 1 row format in that 0 = reference homozygous, 2 =
alternate homozygous, 1 = heterozyous, and NA = missing SNP assignment.
}
\examples{
gl.write.csv(testset.gl, outfile="SNP_1row.csv")
}
\author{
Arthur Georges (glbugs@aerg.canberra.edu.au)
}
