% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.report.reproducibility.r
\name{gl.report.reproducibility}
\alias{gl.report.reproducibility}
\title{Reports summary of RepAvg (repeatability averaged over both alleles 
for
each locus) or reproducibility (repeatability of the scores for fragment
presence/absence)}
\usage{
gl.report.reproducibility(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.dir = NULL,
  plot.file = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP or presence/absence
(SilicoDArT) data [required].}

\item{plot.display}{Specify if plot is to be produced [default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options [default
theme_dartR()].}

\item{plot.colors}{Vector with two color names for the borders and fill
[default c("#2171B5", "#6BAED6")].}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{plot.file}{Filename (minus extension) for the RDS plot file [Required for plot save]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
An unaltered genlight object
}
\description{
SNP datasets generated by DArT have an index, RepAvg, generated by
reproducing the data independently for 30% of loci. RepAvg is the proportion
of alleles that give a repeatable result, averaged over both alleles for each
locus.
In the case of fragment presence/absence data (SilicoDArT), repeatability is
the percentage of scores that are repeated in the technical replicate
 dataset.
}
\details{
The function displays a table of minimum, maximum, mean and quantiles for
 repeatbility against possible thresholds that might subsequently be
 specified in \code{\link{gl.filter.reproducibility}}.
 If plot.display=TRUE, display also includes a boxplot and a histogram to guide
 in the selection of a threshold for filtering on repeatability.
  If plot.file is specified, plots are saved to the directory specified by the user, or the global
  default working directory set by gl.set.wd() or to the tempdir().
 For examples of themes, see:
   \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and 
 \item
  \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
}
\examples{
 \donttest{
# SNP data
  out <- gl.report.reproducibility(testset.gl)
  }
# Tag P/A data
  out <- gl.report.reproducibility(testset.gs)
}
\seealso{
\code{\link{gl.filter.reproducibility}}

Other matched report: 
\code{\link{gl.report.allna}()},
\code{\link{gl.report.callrate}()},
\code{\link{gl.report.hamming}()},
\code{\link{gl.report.locmetric}()},
\code{\link{gl.report.maf}()},
\code{\link{gl.report.overshoot}()},
\code{\link{gl.report.pa}()},
\code{\link{gl.report.rdepth}()},
\code{\link{gl.report.secondaries}()},
\code{\link{gl.report.taglength}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched report}
