% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.mahal.assign.r
\name{gl.mahal.assign}
\alias{gl.mahal.assign}
\title{Assigns individuals to populations with an associated probability}
\usage{
gl.mahal.assign(
  x,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object [required].}

\item{plot.display}{If TRUE, resultant plots are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5","#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log; 3, progress and results summary; 5, full report
 [default NULL, unless specified using gl.set.verbosity]}
}
\value{
The unchanged genlight object
}
\description{
Uses Mahalanobis Distances between individuals and group centroids to
calculate probability of group membership
}
\details{
The function generates 200 simulated individuals for each group (=population in the
genlight object) drawing from the observed allele frequencies for each group.
The group centroids and covariance matricies are calculated for these simulated
groups. The covariance matrix is inverted using package MASS::ginv to overcome the
singularities that would otherwise arise with typical SNP data. Mahanobilis
Distances are calculated using stats::mahanalobis for each individual in the
dataset and associated Chi Square probabilities of group membership are calculated for
each individual in the original genlight object. The resultant table can be
used for decisions on group membership. A special group (=population in the
genlight object) called 'unknowns' can be used to specifically identify 
individuals with unknown group membership.

 A color vector can be obtained with gl.select.colors() and then passed to the function
 with the plot.colors parameter.
Themes can be obtained from in \itemize{
 \item \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} and \item
 \url{https://yutannihilation.github.io/allYourFigureAreBelongToUs/ggthemes/}
 }
  If a plot.file is given, the ggplot arising from this function is saved as an "RDS" 
binary file using saveRDS(); can be reloaded with readRDS(). A file name must be 
specified for the plot to be saved.
 If a plot directory (plot.dir) is specified, the ggplot binary is saved to that
 directory; otherwise to the tempdir().
}
\seealso{
Other matched reports: 
\code{\link{gl.report.bases}()},
\code{\link{gl.report.factorloadings}()},
\code{\link{gl.report.fstat}()},
\code{\link{gl.report.monomorphs}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{matched reports}
