% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.filter.reproducibility.r
\name{gl.filter.reproducibility}
\alias{gl.filter.reproducibility}
\title{Filters loci in a genlight \{adegenet\} object based on average
 repeatability of alleles at a locus
 @family matched filter}
\usage{
gl.filter.reproducibility(
  x,
  threshold = 0.99,
  plot.display = TRUE,
  plot.theme = theme_dartR(),
  plot.colors = NULL,
  plot.file = NULL,
  plot.dir = NULL,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object containing the SNP data [required].}

\item{threshold}{Threshold value below which loci will be removed
[default 0.99].}

\item{plot.display}{If TRUE, histograms of base composition are displayed in the plot window
[default TRUE].}

\item{plot.theme}{Theme for the plot. See Details for options
[default theme_dartR()].}

\item{plot.colors}{List of two color names for the borders and fill of the
plots [default c("#2171B5", "#6BAED6")].}

\item{plot.file}{Name for the RDS binary file to save (base name only, exclude extension) [default NULL]}

\item{plot.dir}{Directory in which to save files [default = working directory]}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress log ; 3, progress and results summary; 5, full report
[default 2, unless specified using gl.set.verbosity].}
}
\value{
Returns a genlight object retaining loci with repeatability (Repavg
or Reproducibility) greater than the specified threshold.
}
\description{
SNP datasets generated by DArT have an index, RepAvg, generated by
reproducing the data independently for 30% of loci. RepAvg is the proportion
of alleles that give a repeatable result, averaged over both alleles for each
locus.
SilicoDArT datasets generated by DArT have a similar index, Reproducibility.
For these fragment presence/absence data, repeatability is the percentage of
scores that are repeated in the technical replicate dataset.
}
\examples{
 \donttest{
# SNP data
  gl.report.reproducibility(testset.gl)
  result <- gl.filter.reproducibility(testset.gl, threshold=0.99, verbose=3)
# Tag P/A data
  gl.report.reproducibility(testset.gs)
  result <- gl.filter.reproducibility(testset.gs, threshold=0.99)
  }
  res <- gl.filter.reproducibility(testset.gl)
  
}
\seealso{
\code{\link{gl.report.reproducibility}}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
