% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_eigenvalues.R
\name{graph_eigenvalues.default}
\alias{graph_eigenvalues.default}
\title{A helper for sub_dann}
\usage{
\method{graph_eigenvalues}{default}(
  x,
  neighborhood_size = max(floor(nrow(x)/5), 50),
  weighted = FALSE,
  sphere = "mcd",
  ...
)
}
\arguments{
\item{x}{A data frame.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{sphere}{One of "mcd", "mve", "classical", or "none" See \code{\link[fpc:ncoord]{fpc::ncoord()}} for details.}

\item{...}{Additional parameters passed to methods.}
}
\value{
A ggplot2 graph.
}
\description{
A helper for sub_dann
}
\details{
This function plots the eigenvalues found by \code{\link[fpc:ncoord]{fpc::ncoord()}}. The user
should make a judgement call on how many eigenvalues are large and set sub_dann's
numDim to that number.
}
