% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_dann.R
\name{sub_dann_source}
\alias{sub_dann_source}
\title{Discriminant Adaptive Nearest Neighbor With Subspace Reduction}
\usage{
sub_dann_source(xTrain, yTrain, xTest, k = 5,
  neighborhood_size = max(floor(nrow(xTrain)/5), 50), epsilon = 1,
  probability = FALSE, weighted = FALSE, sphere = "mcd",
  numDim = ncol(xTrain)/2)
}
\arguments{
\item{xTrain}{Train features. Something easily converted to a numeric matrix.}

\item{yTrain}{Train classes. Something easily converted to a numeric vector.}

\item{xTest}{Test features. Something easily converted to a numeric matrix.}

\item{k}{The number of data points used for final classification.}

\item{neighborhood_size}{The number of data points used to calculate between and within class covariance.}

\item{epsilon}{Diagonal elements of a diagonal matrix. 1 is the identity matrix.}

\item{probability}{Should probabilities instead of classes be returned?}

\item{weighted}{weighted argument to ncoord. See \code{\link[fpc]{ncoord}} for details.}

\item{sphere}{weighted argument to ncoord. See \code{\link[fpc]{ncoord}} for details.}

\item{numDim}{Dimension of subspace used by dann. See \code{\link[fpc]{ncoord}} for details.}
}
\value{
A numeric vector containing predicted class or a numeric matrix containing class probabilities.
}
\description{
Discriminant Adaptive Nearest Neighbor With Subspace Reduction
}
\keyword{internal}
