% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twsa.R
\name{twsa}
\alias{twsa}
\title{Two-way sensitivity analysis using linear regression metamodeling}
\usage{
twsa(
  sa_obj,
  param1 = NULL,
  param2 = NULL,
  ranges = NULL,
  nsamp = 100,
  outcome = c("eff", "cost", "nhb", "nmb", "nhb_loss", "nmb_loss"),
  wtp = NULL,
  strategies = NULL,
  poly.order = 2
)
}
\arguments{
\item{sa_obj}{sensitivity analysis object;
either a probabilistic sensitivity analysis (\code{\link{make_psa_obj}}) or
a deterministic sensitivity analysis object (\code{\link{run_owsa_det}})}

\item{param1}{String with the name of the first parameter of interest}

\item{param2}{String with the name of the second parameter of interest}

\item{ranges}{a named list of the form c("param" = c(0, 1), ...)
that gives the ranges for the parameter of interest. If NULL,
parameter values from the middle 95% of the PSA samples are used. The number of samples
from this range is determined by \code{nsamp}.}

\item{nsamp}{number of samples from ranges}

\item{outcome}{either effectiveness ("eff"), cost ("cost"), net health benefit ("nhb"),
net monetary benefit ("nmb"), or the opportunity loss in terms of NHB or
NMB ("nhb_loss" and "nmb_loss", respectively). "nmb_loss_voi" and "nhb_loss_voi" are only
used in internal function calls of metamodel within other VOI functions.}

\item{wtp}{if outcome is NHB or NMB (or the associated loss), must provide the willingness-to-pay threshold}

\item{strategies}{vector of strategies to consider. The default (NULL) is that all strategies are considered.}

\item{poly.order}{order of polynomial for the linear regression metamodel.
Default: 2}
}
\value{
twsa A \code{ggplot2} object with the TWSA graph of \code{param1} and
\code{param2} on the outcome of interest.
}
\description{
This function displays a two-way sensitivity analysis (TWSA) graph
by estimating a linear regression metamodel of a PSA for a given
decision-analytic model
}
