% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post_processing.R
\name{ranef.dalmatian}
\alias{ranef.dalmatian}
\title{Random Effects (dalmatian)}
\usage{
\method{ranef}{dalmatian}(object, nstart = start(object$coda),
  nend = end(object$coda), nthin = thin(object$coda), ...)
}
\arguments{
\item{object}{Object of class \code{dalmatian} created by \code{dalmatian()}.}

\item{nstart}{Start point for computing summary statistics (relative to true start of chain).}

\item{nend}{End point for computing summary statistics (relative to true start of chain).}

\item{nthin}{Thinning factor for computing summary statsitics (relative to full chain and not previously thinned output).}

\item{...}{Ignored}
}
\value{
output (list)
}
\description{
Compute posterior summary statistics for the individual random effects in each part of the model.
}
\examples{

## Load output from previously run model
load(system.file("Pied_Flycatchers_1","pfresults.RData",package="dalmatian"))

## Compute numerical summaries
ranef(pfresults)

}
