% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/field_types.R
\name{field_types_advanced}
\alias{field_types_advanced}
\title{Create field_types_advanced specification}
\usage{
field_types_advanced(..., .default_field_type = ft_simple())
}
\arguments{
\item{...}{names and types of fields (columns) in source data.}

\item{.default_field_type}{\code{field_type} to use for any remaining fields (columns) in source
data. Note, this means there can not be a field in the data named \code{.default_field_type}}
}
\value{
A \code{field_types} object
}
\description{
Specify only a subset of the names and types of fields in the source data frame. The remaining
fields will be given the same 'default' type.
}
\examples{
fts <- field_types_advanced(
  PrescriptionDate = ft_timepoint(),
  PatientID = ft_ignore(),
  .default_field_type = ft_simple()
)

fts
}
\seealso{
\code{\link[=field_types]{field_types()}}, \code{\link[=field_types_available]{field_types_available()}}, \code{\link[=template_field_types]{template_field_types()}}
}
