% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_output.R
\name{draw_lines}
\alias{draw_lines}
\title{Inspect line bounding boxes}
\usage{
draw_lines(
  type,
  output,
  doc = NA,
  prefix = NULL,
  dir = getwd(),
  linecol = "red",
  linewd = 3,
  fontcol = "blue",
  fontsize = 4
)
}
\arguments{
\item{type}{one of "sync", "async", "sync-tab" or "async-tab", depending on
the function used to process the document.}

\item{output}{either a HTTP response object (from \code{dai_sync()} or
\code{dai_sync_tab()}) or the path to a JSON file (from \code{dai_async} or
\code{dai_async_tab()}).}

\item{doc}{filepath to the source document (pdf, tiff, or gif file); only
necessary for documents processed with \code{dai_sync_tab()} or \code{dai_async_tab()}.}

\item{prefix}{string to be prepended to the output png filename.}

\item{dir}{path to the desired output directory.}

\item{linecol}{color of the bounding box line.}

\item{linewd}{width of the bounding box line.}

\item{fontcol}{color of the box numbers.}

\item{fontsize}{size of the box numbers.}
}
\value{
no return value, called for side effects.
}
\description{
Plots the line bounding boxes identified by
Document AI (DAI) onto images of the submitted document.
Generates an annotated .png file for each page in the original
document.
}
\details{
Not vectorized, but documents can be multi-page.
}
\examples{
\dontrun{
resp <- dai_sync("page.pdf")
draw_lines(type = "sync",
           output = resp)

resp <- dai_sync_tab("page.pdf")
draw_lines(type = "sync-tab",
           output = resp,
           doc = "page.pdf")

draw_lines(type = "async",
           output = "page.json")

draw_lines(type = "async-tab",
           output = "page.json",
           doc = "page.pdf")
}
}
