% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_stats.R
\name{new_stats_dm}
\alias{new_stats_dm}
\title{Create a New stats_dm Object}
\usage{
new_stats_dm(stat_df, type, ...)
}
\arguments{
\item{stat_df}{a \code{data.frame}, containing calculated statistics to be
encapsulated within the \code{stats_dm} class.}

\item{type}{a character string, specifying the type of statistic provided by
\code{stat_df}. Valid options include \code{"cafs"}, \code{"quantiles"}, \code{"delta_funs"},
and \code{"fit_stats"}.}

\item{...}{Additional arguments passed to set attributes. For \code{"cafs"},
\code{"quantiles"}, and \code{"delta_funs"}, a \code{b_coding} attribute is required.}
}
\value{
An object of class \code{stats_dm}, with additional classes and attributes
depending on \code{type}.
}
\description{
\code{new_stats_dm} initializes a \code{stats_dm} object to label statistic types and
store necessary attributes for the custom methods (such as \verb{plot_*})
}
\details{
\code{new_stats_dm} sets up the \code{stat_df} object by assigning it the class
\code{stats_dm}, along with additional classes based on the specified \code{type}.
For"cafs", "quantiles", "delta_funs", this will be c(\verb{<type>}, "sum_dist",
"stats_dm", "data.frame")". For fit statistics, this will be c("fit_stats",
"stats_dm", "data.frame")".

For Conditional Accuracy Functions (CAFs), Quantiles, and Delta Functions,
the function requires a \code{b_coding} argument, which specifies boundary coding
details and is set as an attribute.

The function performs validation through \link{validate_stats_dm} to
ensure that the \code{stats_dm} object is well formatted.
}
\keyword{internal}
