% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{+.datalist}
\alias{+.datalist}
\alias{sumdatalist}
\title{Direct sum of datasets}
\usage{
\method{+}{datalist}(data1, data2)
}
\arguments{
\item{data1}{dataset of class \code{datalist}}

\item{data2}{dataset of class \code{datalist}}
}
\value{
Object of class \code{datalist} for the
union of conditions.
}
\description{
Used to merge datasets with overlapping conditions.
}
\details{
Each data list contains data frames for a number of conditions.
The direct sum of datalist is meant as merging the two data lists and
returning the overarching datalist.
}
\examples{
  
  # Start with two data frames
  mydata1 <- data.frame(
    name = "A",
    time = 0:1,
    value = 1:2,
    sigma = .1,
    compound = c("DEM", "APAP"),
    dose = "0.1"
  )
  
  mydata2 <- data.frame(
    name = "A",
    time = 0:1,
    value = 3:4,
    sigma = .1,
    compound = c("APAP", "DCF"),
    dose = "0.1"
  )
 
  # Create datalists from dataframes
  data1 <- as.datalist(mydata1, split.by = c("compound", "dose")) 
  data2 <- as.datalist(mydata2, split.by = c("compound", "dose")) 
  
  # Direct sum of datalists
  data <- data1 + data2
   print(data)
  
  # Check the condition.grid (if available)
  condition.grid <- attr(data, "condition.grid")
   print(condition.grid)

}
