% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toolsWolfgang.R
\name{reduceReplicates}
\alias{reduceReplicates}
\title{Reduce replicated measurements to mean and standard deviation}
\format{The following columns are mandatory for the data file.
\describe{
 \item{name}{Name of the observed species.}
 \item{time}{Measurement time point.}
 \item{value}{Measurement value.}
 \item{condition}{The condition under which the observation was made.}
}

In addition to these columns, any number of columns can follow to allow a
fine grained definition of conditions. The values of all columns named in
\option{select} are then merged to get the set of conditions.}
\usage{
reduceReplicates(file, select = "condition", datatrans = NULL)
}
\arguments{
\item{file}{Data file of csv. See Format for details.}

\item{select}{Names of the columns in the data file used to define
conditions, see Details.}

\item{datatrans}{Character vector describing a function to transform data.
Use \kbd{x} to refere to data.}
}
\value{
A data frame of the following variables
\describe{
 \item{time}{Measurement time point.}
 \item{name}{Name of the observed species.}
 \item{value}{Mean of replicates.}
 \item{sigma}{Standard error of the mean, NA for single measurements.}
 \item{n}{The number of replicates reduced.}
 \item{condition}{The condition for which the value and sigma were calculated. If
       more than one column were used to define the condition, this variable
       holds the effecive condition which is the combination of all applied
       single conditions. }
}
}
\description{
Obtain the mean and standard deviation from replicates per condition.
}
\details{
Experiments are usually repeated multiple times possibly under different
conditions leading to replicted measurements. The column "Condition" in the
data allows to group the data by their condition. However, sometimes, a more
fine grained grouping is desirable. In this case, any number of additional
columns can be append to the data. These columns are referred to as
"condition identifier". Which of the condition identifiers are used to do the
grouping is user defined by anouncing the to \option{select}. The mandatory
column "Condition" is always used. The total set of different conditions is
thus defined by all combinations of values occuring in the selected condition
identifiers. The replicates of each condition are then reduced to mean and
variance.New conditions names are derived by merging all conditions which
were used in mean and std.
}
\author{
Wolfgang Mader, \email{Wolfgang.Mader@fdm.uni-freiburg.de}
}

