% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierarchy.R
\name{d3_nest}
\alias{d3_nest}
\title{Convert a \code{data.frame} to a 'd3.js' Hierarchy}
\usage{
d3_nest(data = NULL, value_cols = character(), root = "root",
  json = TRUE)
}
\arguments{
\item{data}{\code{data.frame} or \code{data.frame} derivative, such
as \code{tibble}}

\item{value_cols}{\code{character} vector with the names of the
columns to use as data}

\item{root}{\code{character} name of the root level of the hierarchy}

\item{json}{\code{logical} to return as \code{JSON}}
}
\value{
nested \code{data.frame}
}
\description{
Convert a \code{data.frame} to a 'd3.js' Hierarchy
}
\examples{
# convert Titanic to a nested d3 hierarchy

# devtools::install_github("timelyportfolio/d3r")
library(d3r)
library(dplyr)

titanic_df <- data.frame(Titanic)
tit_tb <- titanic_df \%>\%
  select(Class,Age,Survived,Sex,Freq) \%>\%
  d3_nest(value_cols="Freq", root="titanic")

tit_tb

# see as tibble
titanic_df \%>\%
  select(Class,Age,Survived,Sex,Freq) \%>\%
  d3_nest(value_cols="Freq", root="titanic", json=FALSE)

# see the structure with listviewer
tit_tb \%>\%
  listviewer::jsonedit()
\dontrun{
  library(treemap)
  library(d3r)
  library(dplyr)
  library(tidyr)

  treemap::random.hierarchical.data() \%>\%
    d3_nest(value_cols = "x")

  # use example from ?treemap
  data(GNI2014)
  treemap(
    GNI2014,
    index=c("continent", "iso3"),
    vSize="population",
    vColor="GNI",
    type="value",
    draw=FALSE
  ) \%>\%
    {.$tm} \%>\%
    select(continent,iso3,color,vSize) \%>\%
    d3_nest(value_cols = c("color", "vSize"))
}
}
