% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/competitive_ability.R
\name{competitive_ability}
\alias{competitive_ability}
\title{Competitive ability among pairs of species}
\usage{
competitive_ability(
  cxr_multifit = NULL,
  cxr_sp1 = NULL,
  cxr_sp2 = NULL,
  lambda = NULL,
  pair_matrix = NULL,
  model_family = NULL
)
}
\arguments{
\item{cxr_multifit}{cxr_pm_multifit object, with parameters for a series of species.}

\item{cxr_sp1}{cxr_pm_fit object giving the parameters from the first species.}

\item{cxr_sp2}{cxr_pm_fit object giving the parameters from the second species.}

\item{lambda}{numeric lambda value of the focal species.}

\item{pair_matrix}{2x2 matrix with intra and interspecific interaction
coefficients between the focal and competitor species.}

\item{model_family}{model family for which to calculate competitive ability.}
}
\value{
data frame with variable number of rows and three columns, specifying taxa identity and the competitive ability
of focal species (sp1) relative to the competitor (sp2).
}
\description{
Computes the competitive ability among two species, as defined by Hart et al. (2018). This metric, as others in MCT, is
model-specific; the formulation for a series of Lotka-Volterra-like models is given in table A1 of Hart et al. (2018).
We include in \code{cxr} by default the formulation for Beverton-Holt, Ricker, Law-Watkinson, and Lotka-Volterra families.
}
\details{
The function, as in \code{avg_fitness_diff} and \code{niche_overlap}, accepts three different parameterizations:
\itemize{
\item A cxr_pm_multifit object, from which competitive ability of a focal species relative to a given competitor
will be computed across all species pairs.
\item two cxr_pm_fit objects, one for a focal species and one for a competitor.
\item explicit lambda and alpha values, as well as the model family from which these parameters were obtained.
}

If the third parameterization is used, the function will try to find a model-specific function
for obtaining the competitive ability, by looking at the 'model_family' parameter.
If this specific function is not found, it will resort to the standard Lotka-Volterra
formulation (lambda - 1 in the numerator term, Hart et al. 2018).
Overall, we strongly suggest that you use the standard formulation ONLY if you are completely confident
that the model from which you obtained your parameters is consistent with it.
Otherwise, you should include your own formulation of competitive ability (see vignette 4).
}
\examples{
competitive_ability(lambda = runif(1,1,10),
                              pair_matrix = matrix(runif(4,0,1),nrow = 2),
                              model_family = "BH")
}
