% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ner.R
\name{conll_get_regions}
\alias{conll_get_regions}
\title{Extract regions from NER annotations (CoNNL format).}
\usage{
conll_get_regions(x)
}
\arguments{
\item{x}{A \code{data.frame}, a \code{data.table}, or any other object that
can be coerced to a \code{data.table}. The input table is expected to have
the columns "token" and "ner", and "cpos".}
}
\description{
Extract regions from NER annotations (CoNNL format).
}
\examples{
x <- data.frame(
  token = c(
    "Die",
    "Bundeskanzlerin",
    "Angela",
    "Merkel",
    "hält",
    "im",
    "Bundestag",
    "eine",
    "Rede",
    "."
  ),
  ne = c("O", "O", "B-PERS", "I-PERS", "O", "O", "B-ORG", "O", "O", "O"),
  stringsAsFactors = FALSE
)
x[["cpos"]] <- 100L:(100L + nrow(x) - 1L)
tab <- conll_get_regions(x)
}
