% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_raw_data}
\alias{cvd_indicator_raw_data}
\title{Indicator raw data (JSON)}
\usage{
cvd_indicator_raw_data(
  indicator_id = 1,
  time_period_id = 1,
  system_level_id = 1
)
}
\arguments{
\item{indicator_id}{integer - indicator for which to return data for (compulsory)}

\item{time_period_id}{integer - time period for which to return data for (compulsory)}

\item{system_level_id}{integer - system level for which to return data for (compulsory)}
}
\value{
Tibble of metric performance details for a specified indicator across the system level
}
\description{
Returns all metric data for a specified indicator, system level and time
period.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2F\%3Cindicator_ID\%3E\%2FrawDataJSON}{Indicator raw data JSON}
}
\examples{
# return all metric data for indicator 'AF: treatment with anticoagulants'
# (indicator ID 7) in time period 17 at GP practice level (system level ID 5):
cvd_indicator_raw_data(indicator_id = 7, time_period_id = 17, system_level_id = 5) |>
  dplyr::slice_head(n = 5) |>
  dplyr::select(AreaCode, AreaName, Value)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
