% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_metric_timeseries}
\alias{cvd_indicator_metric_timeseries}
\title{Indicator time series by metric}
\usage{
cvd_indicator_metric_timeseries(metric_id = 1, area_id = 50)
}
\arguments{
\item{metric_id}{integer - the metric to return data for (compulsory)}

\item{area_id}{integer - the area to return data for (compulsory)}
}
\value{
Tibble of time-series data for the specified metric in the area
}
\description{
Returns data for the time series chart for specified metric ID and area ID.
Contains an array of two areas in \code{Areas}, one of which is the National data
with the other corresponding to the provided area ID. \code{TargetValue} is also
returned in the \code{Data} dictionary.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FtimeSeriesByMetric\%2F\%3Cmetric_ID\%3E}{Indicator time series metrics}
}
\examples{
# List data for Salford South East PCN (area ID 705) for 'AF: treatment with
# anticoagulants' for women people aged 60-79 years (metric ID 130):
cvd_indicator_metric_timeseries(metric_id = 130, area_id = 705) |>
  dplyr::select(AreaName, TimePeriodName, TimePeriodID, Value) |>
  tidyr::pivot_wider(
    names_from = AreaName,
    values_from = Value
  )
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}}, \code{\link[=cvd_indicator_metric_systemlevel_comparison]{cvd_indicator_metric_systemlevel_comparison()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
