% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoefQuartVar.R
\name{CoefQuartVar}
\alias{CoefQuartVar}
\title{R6 Coefficient of Quartile Variation (cqv)}
\arguments{
\item{x}{An \code{R} object. Currently there are methods for numeric vectors}

\item{na.rm}{a logical value indicating whether \code{NA} values should be
stripped before the computation proceeds.}

\item{digits}{integer indicating the number of decimal places to be used.}
}
\description{
The R6 class \code{CoefQuartVar} for the coefficient of quartile
  variation (cqv)
}
\details{
\describe{ \item{\strong{Coefficient of Quartile Variation}}{
  \emph{cqv} is a measure of relative dispersion that is based on
  interquartile range \emph{(iqr)}. Since \eqn{cqv} is unitless, it is useful
  for comparison of variables with different units. It is also a measure of
  homogeneity \code{[1]}. } }
}
\examples{
x <- c(
   0.2, 0.5, 1.1, 1.4, 1.8, 2.3, 2.5, 2.7, 3.5, 4.4,
   4.6, 5.4, 5.4, 5.7, 5.8, 5.9, 6.0, 6.6, 7.1, 7.9
)
CoefQuartVar$new(x)$est()
cqv_x <- CoefQuartVar$new(x, digits = 2)
cqv_x$est()
R6::is.R6(cqv_x)
}
\references{
\code{[1]} Bonett, DG., 2006, Confidence interval for a
  coefficient of quartile variation, Computational Statistics & Data
  Analysis, 50(11), 2953-7, DOI:
  \href{http://doi.org/10.1016/j.csda.2005.05.007}{http://doi.org/10.1016/j.csda.2005.05.007}
}
