% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{stations}
\alias{stations}
\alias{stations_sf}
\alias{meteo}
\alias{meteo_ts}
\alias{climate_flat}
\alias{climate_mel}
\title{Toy climate data}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 3 rows and 6 columns.

An object of class \code{sf} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 3 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 30 rows and 5 columns.

An object of class \code{tbl_ts} (inherits from \code{tbl_df}, \code{tbl}, \code{data.frame}) with 30 rows and 5 columns.

An object of class \code{tbl_df} (inherits from \code{tbl}, \code{data.frame}) with 30 rows and 10 columns.

An object of class \code{spatial_cubble_df} (inherits from \code{cubble_df}, \code{tbl_df}, \code{tbl}, \code{data.frame}) with 3 rows and 7 columns.
}
\usage{
stations

stations_sf

meteo

meteo_ts

climate_flat

climate_mel
}
\description{
Daily measure (2020-01-01 to 2020-01-10) on precipitation (prcp),
maximum temperature (tmax), and minimum temperature (tmin)
for 3 melbourne airport stations. \code{stations} is the spatial component,
(\code{stations_sf} as an sf object), \code{meteo} has the temporal component
(\code{meteo_ts} as a tsibble object), \code{climate_flat} has both
in a single joined table, and \code{climate_mel} is the cubble object.
See \code{climate_aus} on the full dataset.
}
\examples{
cb <- make_cubble(
  spatial = stations, temporal = meteo,
  key = id, index = date, coords = c(long, lat)
)
identical(cb, climate_mel)
cb2 <- climate_flat \%>\%
  as_cubble(key = id, index = date, coords = c(long, lat))
identical(cb, climate_mel)
}
\seealso{
climate_aus
}
\keyword{datasets}
