% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_weight.R
\name{est_optimal_codons}
\alias{est_optimal_codons}
\title{Estimate optimal codons}
\usage{
est_optimal_codons(
  cf,
  codon_table = get_codon_table(),
  level = "subfam",
  gene_score = NULL,
  fdr = 0.001
)
}
\arguments{
\item{cf}{matrix of codon frequencies as calculated by `count_codons()`.}

\item{codon_table}{a table of genetic code derived from `get_codon_table` or `create_codon_table`.}

\item{level}{"subfam" (default) or "amino_acid". For which level to determine optimal codons.}

\item{gene_score}{a numeric vector of scores for genes. The order of values should match with
gene orders in the codon frequency matrix. The length of the vector should be equal to the
number of rows in the matrix. The scores could be gene expression levels (RPKM or TPM) that are
optionally log-transformed (for example, with `log1p`). The opposite of ENC will be used by
default if `gene_score` is not provided.}

\item{fdr}{false discovery rate used to determine optimal codons.}
}
\value{
data.table of optimal codons.
}
\description{
\code{est_toptimal_codons} determine optimal codon of each codon family with binomial regression.
  Usage of optimal codons should correlate negatively with enc.
}
\examples{
# perform binomial regression for optimal codon estimation
cf_all <- count_codons(yeast_cds)
codons_opt <- est_optimal_codons(cf_all)
codons_opt <- codons_opt[optimal == TRUE]
codons_opt

}
