% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_cts.R
\encoding{UTF-8}
\name{plot_cts}
\alias{plot_cts}
\title{Constructs a categorical time series plot}
\usage{
plot_cts(series, title = "Time series plot")
}
\arguments{
\item{series}{An object of type \code{tsibble} (see R package \code{tsibble}), whose column named Values
contains the values of the corresponding CTS. This column must be of class \code{factor} and its levels
must be determined by the range of the CTS.}

\item{title}{The title of the graph.}
}
\value{
The categorical time series plot.
}
\description{
\code{plot_cts} constructs a categorical time series plot
}
\details{
Constructs a categorial time series plot for a given CTS.
}
\examples{
sequence_1 <- GeneticSequences[which(GeneticSequences$Series==1),]
time_series_plot <- plot_cts(series = sequence_1) # Constructs a categorical
# time series plot for the first 50 observations of the first  time series in
# dataset GeneticSequences
}
\references{
{

  \insertRef{weiss2018introduction}{ctsfeatures}

}
}
\author{
Ángel López-Oriona, José A. Vilar
}
