% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctPostPredict.R
\name{ctPostPredict}
\alias{ctPostPredict}
\title{Posterior predictive type check for ctsemFit.}
\usage{
ctPostPredict(fit, timestep = 0.1, n.subjects = 100, probs = c(0.025,
  0.5, 0.975), plot = TRUE, ctPlotArrayArgs = list(grid = FALSE, legend
  = FALSE), indPlotArgs = list(colourby = "subject", lwd = 2, new =
  FALSE, type = "p", opacity = 0.3), mfrow = "auto")
}
\arguments{
\item{fit}{object of class ctsemFit as returned from \code{\link{ctFit}}}

\item{timestep}{positive value denoting the time interval to use for sampling.}

\item{n.subjects}{Number of subjects worth of data to sample.}

\item{probs}{Vector of values between 0 and 1 denoting quantiles to generate. 
For plotting, vector should be of length 3 and values should be rising.}

\item{plot}{Whether to plot or return the generated data.}

\item{ctPlotArrayArgs}{additional arguments to pass to \code{\link{ctPlotArray}} function,
for plotting generated distributions.}

\item{indPlotArgs}{list of parameters to pass to ctIndplot, for 
plotting original data. Only used if plot=TRUE.}

\item{mfrow}{2 dimensional integer vector defining number of rows and columns of plots,
as per the mfrow argument to \code{\link[graphics]{par}}.
'auto' determines automatically, to a maximum of 4 by 4, while \code{NULL} 
uses the current system setting.}
}
\value{
Either nothing (if plot=TRUE) or an array containing generated data over quantiles.
}
\description{
Samples data according to the ctsemFit object, computes quantiles over time based on model fit,
plots these against original data.
}
\examples{
data("AnomAuth")
AnomAuthmodel <- ctModel(LAMBDA = matrix(c(1, 0, 0, 1), nrow = 2, ncol = 2), 
  Tpoints = 5, n.latent = 2, n.manifest = 2, MANIFESTVAR=diag(0, 2), TRAITVAR = 'auto') 
AnomAuthFit <- ctFit(AnomAuth, AnomAuthmodel)
ctPostPredict(AnomAuthFit,timestep=.5,n.subjects=100)
}
