% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ranks.R
\name{cstaubest}
\alias{cstaubest}
\alias{cstauworst}
\title{Projection confidence sets for the tau-best}
\usage{
cstaubest(
  x,
  Sigma,
  tau = 2,
  coverage = 0.95,
  stepdown = TRUE,
  R = 1000,
  na.rm = FALSE,
  seed = NA
)

cstauworst(
  x,
  Sigma,
  tau = 2,
  coverage = 0.95,
  stepdown = TRUE,
  R = 1000,
  na.rm = FALSE,
  seed = NA
)
}
\arguments{
\item{x}{vector of estimates.}

\item{Sigma}{covariance matrix of \code{x}. Note, that it must be covariance matrix
of feature \bold{means}, not features themselves.}

\item{tau}{the confidence set contains indicators for the elements in \code{x} whose rank is less than or equal to \code{tau}.}

\item{coverage}{nominal coverage of the confidence set. Default is 0.95.}

\item{stepdown}{logical; if \code{TRUE} (default), stepwise procedure is used, otherwise single step procedure is used. See Details section for more.}

\item{R}{number of bootstrap replications. Default is 1000.}

\item{na.rm}{logical; if \code{TRUE}, then \code{NA}'s are removed from \code{x} and \code{Sigma} (if any).}

\item{seed}{seed for bootstrap random variable draws. If set to \code{NA} (default), then seed is not set.}
}
\value{
logical vector indicating which of the elements of \code{x} are in the confidence set for the tau-best.
}
\description{
Find a set of populations, which belong to tau-best populations according to
some feature with given confidence.
}
\section{Functions}{
\itemize{
\item \code{cstauworst()}: Projection confidence sets for the tau-worst

Similar method, but for populations, which are tau-worst.
Equivalent to calling \code{cstaubest} with \code{-x}.

}}
\section{Details}{

The confidence set contains indicators for the elements in \code{x} whose rank is less than or equal to \code{tau} with probability approximately equal to the coverage indicated in \code{coverage}.
Parametric bootstrap based on the multivariate normal distribution.

If \code{na.rm=TRUE} and NAs are present, then results are returned for tau-best (worst)
populations among those without NA values, i.e. after NA removal.
}

\examples{
# Setup example data
n <- 10
x <- seq(1, 3, length = n)
Sigma <- matrix(0.001, nrow = n, ncol = n)
diag(Sigma) <- 0.04

# Run csranks to get confidence sets for top 3 populations
cstaubest(x, Sigma, tau = 3)
cstauworst(x, Sigma, tau = 3)

# If you assume that the feature measurements are independent, 
# (or just have access to variances / standard errors)
# then pass a diagonal covariance matrix.
Sigma <- diag(rep(0.04, 10))
cstaubest(x, Sigma, tau = 3)
cstauworst(x, Sigma, tau = 3)

}
\references{
Mogstad, Romano, Shaikh, and Wilhelm (2023), "Inference for Ranks with Applications to Mobility across Neighborhoods and Academic Achievements across Countries", forthcoming at Review of Economic Studies

\href{http://dwilhelm.userweb.mwn.de/papers/cwp0323.pdf}{pdf link}
\doi{10.1093/restud/rdad006}
}
