% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_norway_municip.R
\docType{data}
\name{nor_municip_map_bxxxx_default_dt}
\alias{nor_municip_map_bxxxx_default_dt}
\alias{nor_municip_map_b2020_default_dt}
\alias{nor_municip_map_b2019_default_dt}
\alias{nor_municip_position_geolabels_b2020_default_dt}
\alias{nor_municip_position_geolabels_b2019_default_dt}
\title{Maps of Norwegian municipalities in data.table format}
\format{
\describe{
\item{long}{Location code.}
\item{lat}{Location name.}
\item{order}{The order that this line should be plotted in.}
\item{group}{Needs to be used as 'group' aesthetic in ggplot2.}
\item{location_code}{Location code (municipality code).}
}

An object of class \code{data.table} (inherits from \code{data.frame}) with 31705 rows and 5 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 356 rows and 3 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 422 rows and 3 columns.
}
\usage{
nor_municip_map_b2020_default_dt

nor_municip_map_b2019_default_dt

nor_municip_position_geolabels_b2020_default_dt

nor_municip_position_geolabels_b2019_default_dt
}
\description{
We conveniently package map datasets for Norwegian municipalities
(taken from Geonorge) that can be used in ggplot2 without needing any geo
libraries. This data is licensed under Creative Commons BY 4.0 (CC BY 4.0).
}
\details{
Borders for 2020 and 2019 are provided.
}
\examples{
# 2020 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_municip_map_b2020_default_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  size = 0.2
)
q <- q + theme_void()
q <- q + coord_quickmap()
q

# 2019 borders
library(ggplot2)
q <- ggplot(mapping = aes(x = long, y = lat))
q <- q + geom_polygon(
  data = csmaps::nor_municip_map_b2019_default_dt,
  mapping = aes(group = group),
  color = "black",
  fill = "white",
  size = 0.2
)
q <- q + theme_void()
q <- q + coord_quickmap()
q
}
\keyword{datasets}
