% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_dens_ind.R
\name{calc_dens_ind_3d}
\alias{calc_dens_ind_3d}
\title{Calculate J trivariate normal densities (all dimensions are independent) under fitted csmGmm.}
\usage{
calc_dens_ind_3d(x, Zmat)
}
\arguments{
\item{x}{3*1 vector of means.}

\item{Zmat}{J*3 matrix of test statistics.}
}
\value{
A J*1 vector of densities for each row of Zmat.
}
\description{
Calculate J trivariate normal densities (all dimensions are independent) under fitted csmGmm.
}
\examples{
x <- c(0, 0)
Zmat <- cbind(rnorm(10^5), rnorm(10^5), rnorm(10^5))
calc_dens_ind_3d(x, Zmat)

}
